package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseGiftCard;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "customCardNumber" })
public class GiftCard extends BaseGiftCard implements TimedModel {
	private static final long serialVersionUID = 1L;
	public final static String DURATION_TYPE_DAY = "DAY"; //$NON-NLS-1$
	public final static String DURATION_TYPE_MONTH = "MONTH"; //$NON-NLS-1$
	public final static String DURATION_TYPE_YEAR = "YEAR"; //$NON-NLS-1$
	@XmlTransient
	public String customCardNumber;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public GiftCard() {
	}

	/**
	 * Constructor for primary key
	 */
	public GiftCard(java.lang.String cardNumber) {
		super(cardNumber);
	}

	/*[CONSTRUCTOR MARKER END]*/
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public void setCustomCardNumber(String customCardNumber) {
		this.customCardNumber = customCardNumber;
	}

	public String getCustomCardNumber() {
		StringBuilder gcn = new StringBuilder(super.getCardNumber());
		for (int i = 0; i < gcn.length(); i++) {
			if (i == 4 || i == 9 || i == 14) {
				gcn.insert(i, "-"); //$NON-NLS-1$
			}
		}

		return gcn.toString();
	}

	@Override
	public String toString() {
		return super.getCardNumber();
	}
}