package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseQuotation;
import com.orocube.rest.service.ServiceUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(XmlAccessType.FIELD)
public class Quotation extends BaseQuotation {
	private static final long serialVersionUID = 1L;

	public static final int ORDER_PENDING = 0;
	public static final int ORDER_SENT = 1;
	public static final int ORDER_CONFIMED = 2;

	public static final String[] ORDER_STATUS = { "Open", "Sent", "Confirmed" }; //$NON-NLS-2$ //$NON-NLS-3$
	private Ticket ticket;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Quotation() {
	}

	/**
	 * Constructor for primary key
	 */
	public Quotation(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@XmlTransient
	@JsonIgnore
	public Ticket getTicket() {
		String ticketJson = super.getTicketJson();
		if (ticket == null && StringUtils.isNotBlank(ticketJson)) {
			try {
				ticket = ServiceUtils.convertJsonToTicket(ticketJson);
			} catch (Exception e) {
				PosLog.error(getClass(), e);
			}
		}
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

}