package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the BALANCE_UPDATE_TRANSACTION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="BALANCE_UPDATE_TRANSACTION"
 */

public abstract class BaseBalanceUpdateTransaction  implements Comparable, Serializable {

	public static String REF = "BalanceUpdateTransaction"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_TYPE = "transactionType"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_ACCOUNT_PROCESSED = "accountProcessed"; //$NON-NLS-1$
	public static String PROP_BATCH_NO = "batchNo"; //$NON-NLS-1$
	public static String PROP_RECEPIENT_ID = "recepientId"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_SUB_TYPE = "transactionSubType"; //$NON-NLS-1$
	public static String PROP_BALANCE_TYPE_STRING = "balanceTypeString"; //$NON-NLS-1$
	public static String PROP_ACCOUNT_NUMBER = "accountNumber"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_ID = "transactionId"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_TIME = "transactionTime"; //$NON-NLS-1$
	public static String PROP_FROM_CASHDRAWER_ID = "fromCashdrawerId"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_EVENT_TIME = "eventTime"; //$NON-NLS-1$
	public static String PROP_EXTRA_PROPERTIES = "extraProperties"; //$NON-NLS-1$
	public static String PROP_PAYMENT_TYPE_STRING = "paymentTypeString"; //$NON-NLS-1$
	public static String PROP_REASON_ID = "reasonId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$


	// constructors
	public BaseBalanceUpdateTransaction () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseBalanceUpdateTransaction (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseBalanceUpdateTransaction (
		java.lang.String id,
		java.lang.String balanceTypeString,
		java.lang.String paymentTypeString,
		java.lang.String transactionType,
		java.lang.String transactionSubType) {

		this.setId(id);
		this.setBalanceTypeString(balanceTypeString);
		this.setPaymentTypeString(paymentTypeString);
		this.setTransactionType(transactionType);
		this.setTransactionSubType(transactionSubType);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date eventTime;
				private java.util.Date transactionTime;
				private java.lang.String balanceTypeString;
				private java.lang.String accountNumber;
				private java.lang.Double amount;
				private java.lang.String transactionId;
				private java.lang.String ticketId;
				private java.lang.String outletId;
				private java.lang.String paymentTypeString;
				private java.lang.String transactionType;
				private java.lang.String batchNo;
				private java.lang.String recepientId;
				private java.lang.String reasonId;
				private java.lang.String fromCashdrawerId;
				private java.lang.Boolean accountProcessed;
				private java.lang.String extraProperties;
				private java.lang.Boolean voided;
				private java.lang.String transactionSubType;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: EVENT_TIME
	 */

	public java.util.Date getEventTime () {
			return eventTime;
	}



	/**
	 * Set the value related to the column: EVENT_TIME
	 * @param eventTime the EVENT_TIME value
	 */
			public void setEventTime (java.util.Date eventTime) {
			this.eventTime = eventTime;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_TIME
	 */

	public java.util.Date getTransactionTime () {
			return transactionTime;
	}



	/**
	 * Set the value related to the column: TRANSACTION_TIME
	 * @param transactionTime the TRANSACTION_TIME value
	 */
			public void setTransactionTime (java.util.Date transactionTime) {
			this.transactionTime = transactionTime;
	}



	/**
	 * Return the value associated with the column: BALANCE_TYPE_STRING
	 */

	public java.lang.String getBalanceTypeString () {
			return balanceTypeString;
	}



	/**
	 * Set the value related to the column: BALANCE_TYPE_STRING
	 * @param balanceTypeString the BALANCE_TYPE_STRING value
	 */
			public void setBalanceTypeString (java.lang.String balanceTypeString) {
			this.balanceTypeString = balanceTypeString;
	}



	/**
	 * Return the value associated with the column: ACCOUNT_NUMBER
	 */

	public java.lang.String getAccountNumber () {
			return accountNumber;
	}



	/**
	 * Set the value related to the column: ACCOUNT_NUMBER
	 * @param accountNumber the ACCOUNT_NUMBER value
	 */
			public void setAccountNumber (java.lang.String accountNumber) {
			this.accountNumber = accountNumber;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */

	public java.lang.Double getAmount () {
						return amount == null ? Double.valueOf(0) : amount;
		}



	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_ID
	 */

	public java.lang.String getTransactionId () {
			return transactionId;
	}



	/**
	 * Set the value related to the column: TRANSACTION_ID
	 * @param transactionId the TRANSACTION_ID value
	 */
			public void setTransactionId (java.lang.String transactionId) {
			this.transactionId = transactionId;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PAYMENT_TYPE
	 */

	public java.lang.String getPaymentTypeString () {
			return paymentTypeString;
	}



	/**
	 * Set the value related to the column: PAYMENT_TYPE
	 * @param paymentTypeString the PAYMENT_TYPE value
	 */
			public void setPaymentTypeString (java.lang.String paymentTypeString) {
			this.paymentTypeString = paymentTypeString;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_TYPE
	 */

	public java.lang.String getTransactionType () {
			return transactionType;
	}



	/**
	 * Set the value related to the column: TRANSACTION_TYPE
	 * @param transactionType the TRANSACTION_TYPE value
	 */
			public void setTransactionType (java.lang.String transactionType) {
			this.transactionType = transactionType;
	}



	/**
	 * Return the value associated with the column: BATCH_NO
	 */

	public java.lang.String getBatchNo () {
			return batchNo;
	}



	/**
	 * Set the value related to the column: BATCH_NO
	 * @param batchNo the BATCH_NO value
	 */
			public void setBatchNo (java.lang.String batchNo) {
			this.batchNo = batchNo;
	}



	/**
	 * Return the value associated with the column: RECEPIENT_ID
	 */

	public java.lang.String getRecepientId () {
			return recepientId;
	}



	/**
	 * Set the value related to the column: RECEPIENT_ID
	 * @param recepientId the RECEPIENT_ID value
	 */
			public void setRecepientId (java.lang.String recepientId) {
			this.recepientId = recepientId;
	}



	/**
	 * Return the value associated with the column: REASON_ID
	 */

	public java.lang.String getReasonId () {
			return reasonId;
	}



	/**
	 * Set the value related to the column: REASON_ID
	 * @param reasonId the REASON_ID value
	 */
			public void setReasonId (java.lang.String reasonId) {
			this.reasonId = reasonId;
	}



	/**
	 * Return the value associated with the column: FROM_CASHDRAWER_ID
	 */

	public java.lang.String getFromCashdrawerId () {
			return fromCashdrawerId;
	}



	/**
	 * Set the value related to the column: FROM_CASHDRAWER_ID
	 * @param fromCashdrawerId the FROM_CASHDRAWER_ID value
	 */
			public void setFromCashdrawerId (java.lang.String fromCashdrawerId) {
			this.fromCashdrawerId = fromCashdrawerId;
	}



	/**
	 * Return the value associated with the column: ACCOUNT_PROCESSED
	 */

	public java.lang.Boolean isAccountProcessed () {
					return accountProcessed == null ? Boolean.FALSE : accountProcessed;
		}

	public java.lang.Boolean getAccountProcessed () {
				return accountProcessed == null ? Boolean.FALSE : accountProcessed;
			}


	/**
	 * Set the value related to the column: ACCOUNT_PROCESSED
	 * @param accountProcessed the ACCOUNT_PROCESSED value
	 */
			public void setAccountProcessed (java.lang.Boolean accountProcessed) {
			this.accountProcessed = accountProcessed;
	}



	/**
	 * Return the value associated with the column: EXTRA_PROPERTIES
	 */

	public java.lang.String getExtraProperties () {
			return extraProperties;
	}



	/**
	 * Set the value related to the column: EXTRA_PROPERTIES
	 * @param extraProperties the EXTRA_PROPERTIES value
	 */
			public void setExtraProperties (java.lang.String extraProperties) {
			this.extraProperties = extraProperties;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_SUB_TYPE
	 */

	public java.lang.String getTransactionSubType () {
			return transactionSubType;
	}



	/**
	 * Set the value related to the column: TRANSACTION_SUB_TYPE
	 * @param transactionSubType the TRANSACTION_SUB_TYPE value
	 */
			public void setTransactionSubType (java.lang.String transactionSubType) {
			this.transactionSubType = transactionSubType;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.BalanceUpdateTransaction)) return false;
		else {
			com.floreantpos.model.BalanceUpdateTransaction balanceUpdateTransaction = (com.floreantpos.model.BalanceUpdateTransaction) obj;
			if (null == this.getId() || null == balanceUpdateTransaction.getId()) return this == obj;
			else return (this.getId().equals(balanceUpdateTransaction.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}