package com.floreantpos.util;

import java.text.DecimalFormat;
import java.util.Date;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;

public class BatchNoGenerator {

	public static String generateBatchNo() {

		String date = SequenceNumber.yearMonthDayFormat.format(new Date());

		DecimalFormat decimalFormat = new DecimalFormat("0");
		int num = 0;

		SequenceNumberDAO instance = SequenceNumberDAO.getInstance();
		SequenceNumber lastSequenceNumber = instance.getLastSequenceNumber(SequenceNumber.POS_TRANSACTION_BATCH_NO, date);
		if (lastSequenceNumber != null) {
			num = lastSequenceNumber.getNextSequenceNumber() - 1;
		}
		else {
			num = instance.getNextSequenceNumber(SequenceNumber.POS_TRANSACTION_BATCH_NO, date);
		}

		String batchNo = date + decimalFormat.format(num);

		while (PosTransactionDAO.getInstance().isPresent(batchNo)) {
			batchNo = date + decimalFormat.format(instance.getNextSequenceNumber(SequenceNumber.POS_TRANSACTION_BATCH_NO, date));
		}

		return batchNo;
	}

	public static String generatePayoutBatchNo(boolean isExpenses) {
		if (isExpenses) {
			return generateBatchNoForTransaction(SequenceNumber.EXPENSES_BATCH_NO);
		}
		return generateBatchNoForTransaction(SequenceNumber.PAYOUT_BATCH_NO);
	}

	public static String generateBatchNoForTransaction(String type) {

		String date = SequenceNumber.yearMonthDayFormat.format(new Date());

		DecimalFormat decimalFormat = new DecimalFormat("0");
		int num = 0;

		SequenceNumberDAO instance = SequenceNumberDAO.getInstance();
		SequenceNumber lastSequenceNumber = instance.getLastSequenceNumber(type, date);
		if (lastSequenceNumber != null) {
			num = lastSequenceNumber.getNextSequenceNumber() - 1;
		}
		else {
			num = instance.getNextSequenceNumber(type, date);
		}

		String batchNo = date + decimalFormat.format(num);

		if (SequenceNumber.EXPENSES_BATCH_NO.equals(type)) {
			while (BalanceUpdateTransactionDAO.getInstance().isPresent(batchNo)) {
				batchNo = date + decimalFormat.format(instance.getNextSequenceNumber(type, date));
			}
		}
		else {
			while (PosTransactionDAO.getInstance().isPresent(batchNo)) {
				batchNo = date + decimalFormat.format(instance.getNextSequenceNumber(type, date));
			}
		}

		return batchNo;
	}

	public static String generateReferenceNo() {

		String date = SequenceNumber.yearMonthDayFormat.format(new Date());

		DecimalFormat decimalFormat = new DecimalFormat("000"); //$NON-NLS-1$
		int num = 0;

		SequenceNumberDAO instance = SequenceNumberDAO.getInstance();
		SequenceNumber lastSequenceNumber = instance.getLastSequenceNumber(SequenceNumber.PROP_REFERENCE_NO, date);
		if (lastSequenceNumber != null) {
			num = lastSequenceNumber.getNextSequenceNumber() - 1;
		}
		else {
			num = instance.getNextSequenceNumber(SequenceNumber.PROP_REFERENCE_NO, date);
		}

		String refNo = date + decimalFormat.format(num);

		while (InventoryTransactionDAO.getInstance().isPresent(refNo)) {
			refNo = date + decimalFormat.format(instance.getNextSequenceNumber(SequenceNumber.PROP_REFERENCE_NO, date));
		}

		return refNo;
	}
}
