package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.floreantpos.model.dao.PayoutReasonDAO;
import com.floreantpos.model.dao.PayoutRecepientDAO;
import com.floreantpos.model.dao.PayoutSubReasonDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "paymentType", "balanceType" })
@XmlRootElement
public class BalanceUpdateTransaction extends BaseBalanceUpdateTransaction implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;

	public static final String JSON_PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static final String JSON_PROP_BALANCE_BEFORE = "balance.before"; //$NON-NLS-1$

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public BalanceUpdateTransaction() {
	}

	/**
	 * Constructor for primary key
	 */
	public BalanceUpdateTransaction(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public BalanceUpdateTransaction(java.lang.String id, java.lang.String balanceTypeString, java.lang.String paymentTypeString,
			java.lang.String transactionType, java.lang.String transactionSubType) {

		super(id, balanceTypeString, paymentTypeString, transactionType, transactionSubType);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setPaymentType(PaymentType paymentType) {
		setPaymentTypeString(paymentType != null ? paymentType.name() : null);
	}

	@XmlTransient
	public PaymentType getPaymentType() {
		String paymentTypeString = super.getPaymentTypeString();
		if (paymentTypeString == null) {
			return null;
		}
		return PaymentType.valueOf(paymentTypeString);
	}

	public void setBalanceType(BalanceType balanceType) {
		setBalanceTypeString(balanceType != null ? balanceType.name() : null);
	}

	@XmlTransient
	public BalanceType getBalanceType() {
		String balanceTypeString = super.getBalanceTypeString();
		if (balanceTypeString == null) {
			return null;
		}
		return BalanceType.fromString(balanceTypeString);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public String getExtraProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getExtraProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setExtraProperties(String properties) {
		super.setExtraProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public String getDescription() {
		return getProperty(JSON_PROP_DESCRIPTION);
	}

	public void setDescription(String details) {
		addProperty(JSON_PROP_DESCRIPTION, details);
	}

	public Double getBalanceBefore() {
		return POSUtil.parseDouble(getProperty(JSON_PROP_BALANCE_BEFORE));
	}

	public void setBalanceBefore(double amount) {
		addProperty(JSON_PROP_BALANCE_BEFORE, String.valueOf(amount));
	}

	public String getCustomerName() {
		Customer customer = DataProvider.get().getCustomer(getAccountNumber());
		return customer == null ? "" : customer.getName();
	}

	public void putCustomerName() {

	}

	public String getCustomPaymnetId() {
		return getProperty("custom.paymnet.id", "");
	}

	public void setCustomPaymnetId(String customPaymnetId) {
		addProperty("custom.paymnet.id", customPaymnetId);
	}

	public String getCustomPaymnetRef() {
		return getProperty("custom.paymnet.ref", "");
	}

	public void setCustomPaymnetRef(String customPaymnetRef) {
		addProperty("custom.paymnet.ref", customPaymnetRef);
	}

	public String getPaymentTypeDisplayString() {
		PaymentType paymentType = getPaymentType();
		if (paymentType == PaymentType.CUSTOM_PAYMENT) {
			String customPaymnetId = getCustomPaymnetId();
			CustomPayment customPayment = DataProvider.get().getCustomPaymentById(customPaymnetId, getOutletId());
			if (customPayment != null) {
				return customPayment.getName();
			}
		}
		return paymentType.getDisplayString();
	}

	public String getEventTimeDisplay() {
		Date eventTime = getEventTime();
		return eventTime == null ? StringUtils.EMPTY : DateUtil.formatReportShortDateWithBrowserTimeOffset(eventTime);
	}

	public String getTransactionTimeDisplay() {
		Date startTime = getTransactionTime();
		return startTime == null ? StringUtils.EMPTY : DateUtil.formatReportDateWithBrowserTimeOffset(startTime);
	}

	public String getAccountManager() {
		String userId = getAccountNumber();
		if (StringUtils.isNotBlank(userId)) {
			if (DataProvider.get().getStore().getId().equals(userId)) {
				return "Store";
			}

			User user = DataProvider.get().getUserById(userId, getOutletId());
			if (user != null) {
				return user.getFullName();
			}
		}
		return StringUtils.EMPTY;
	}

	public String getRecepientDisplay() {
		String recepientId = getRecepientId();
		if (StringUtils.isNotEmpty(recepientId)) {
			PayoutRecepient recepient = PayoutRecepientDAO.getInstance().get(recepientId);
			return recepient != null ? recepient.getName() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getReasonDisplay() {
		String reasonId = getReasonId();
		if (StringUtils.isNotEmpty(reasonId)) {
			PayoutReason payoutReason = PayoutReasonDAO.getInstance().get(reasonId);
			return payoutReason != null ? payoutReason.getReason() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getSubCategoryDisplay() {
		String subReasonId = getSubReasonId();
		if (StringUtils.isNotEmpty(subReasonId)) {
			PayoutSubReason subPayoutReason = PayoutSubReasonDAO.getInstance().get(subReasonId);
			return subPayoutReason != null ? subPayoutReason.getReason() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getProjectDisplay() {
		String projectId = getProjectId();
		if (StringUtils.isNotEmpty(projectId)) {
			Project project = ProjectDAO.getInstance().get(projectId);
			return project != null ? project.getName() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public Double getExpenseAmountDisplay() {
		if (getAmount() == 0) {
			return 0d;
		}
		return getAmount() * (-1);
	}
}