package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePrescriptionItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(XmlAccessType.FIELD)
public class PrescriptionItem extends BasePrescriptionItem implements PropertyContainer {
	private static final long serialVersionUID = 1L;
	private transient MenuItem menuItem;
	private transient com.google.gson.JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PrescriptionItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public PrescriptionItem(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public PrescriptionItem(java.lang.String id, com.floreantpos.model.Prescription prescription) {

		super(id, prescription);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null) {
			String itemId = getMenuItemId();
			if (StringUtils.isEmpty(itemId)) {
				return null;
			}
			menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
		}

		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
		String menuItemId = null;
		if (menuItem != null) {
			menuItemId = menuItem.getId();
		}
		super.setMenuItemId(menuItemId);
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = null;
	}

	@Override
	public void addProperty(String key, String value) {
		initPropertyContainer();
		propertiesContainer.addProperty(key, value);
		super.setProperties(propertiesContainer.toString());
	}

	@Override
	public String getProperty(String key) {
		initPropertyContainer();

		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	@Override
	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	private void initPropertyContainer() {
		if (propertiesContainer == null) {
			if (StringUtils.isBlank(super.getProperties())) {
				propertiesContainer = new com.google.gson.JsonObject();
			}
			else {
				propertiesContainer = new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
			}
		}
	}

	@Override
	public void removeProperty(String propertyName) {
		initPropertyContainer();
		propertiesContainer.remove(propertyName);
		super.setProperties(propertiesContainer.toString());
	}

	@Override
	public JsonObject getPropertyStore() {
		initPropertyContainer();
		return propertiesContainer;
	}
}