package com.floreantpos.model;

import java.util.Comparator;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseQuotation;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.orocube.rest.service.ServiceUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(XmlAccessType.FIELD)
public class Quotation extends BaseQuotation implements PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	public static final int ORDER_PENDING = 0;
	public static final int ORDER_SENT = 1;
	public static final int ORDER_CONFIMED = 2;
	public static final int APPROVED = 3;
	public static final int DECLINED = 4;

	public static final String[] ORDER_STATUS = { "Open", "Sent", "Confirmed", "Approved", "Declined" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	private Ticket ticket;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Quotation() {
	}

	/**
	 * Constructor for primary key
	 */
	public Quotation(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@XmlTransient
	@JsonIgnore
	public Ticket getTicket() {
		String ticketJson = super.getTicketJson();
		if (ticket == null && StringUtils.isNotBlank(ticketJson)) {
			try {
				ticket = ServiceUtils.convertJsonToTicket(ticketJson);
			} catch (Exception e) {
				PosLog.error(getClass(), e);
			}
		}
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public List<Comment> getComments() {
		String commentsJson = getProperty("comments", "[]"); //$NON-NLS-1$ //$NON-NLS-2$
		List<Comment> comments = new Gson().fromJson(commentsJson, new TypeToken<List<Comment>>() {
		}.getType());
		comments.sort(Comparator.comparing(Comment::getTime));
		return comments;
	}

	public void putComments(List<Comment> comments) {
		addProperty("comments", new Gson().toJson(comments)); //$NON-NLS-1$
	}

	public void addComment(Comment comment) {
		List<Comment> comments = getComments();
		comments.add(comment);
		addProperty("comments", new Gson().toJson(comments)); //$NON-NLS-1$
	}

	public void putApproved(boolean b) {
		addProperty("isApproved", String.valueOf(b)); //$NON-NLS-1$
	}

	public boolean isApproved() {
		return getBooleanProperty("isApproved", false); //$NON-NLS-1$
	}

	public void putDeclient(boolean b) {
		addProperty("isDeclient", String.valueOf(b)); //$NON-NLS-1$
	}

	public boolean isDeclient() {
		return getBooleanProperty("isDeclient", false); //$NON-NLS-1$
	}
}