package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum RoomType {
	//@formatter:off
		WARD("Ward"), 
		CABIN("Cabin"), 
		ICU("ICU"), 
		NICU("NICU")
		;
		//@formatter:on
	private String displayString;

	private RoomType(String displayString) {
		this.displayString = displayString;
	}

	public static RoomType fromString(String s) {
		if (StringUtils.isBlank(s)) {
			return CABIN;
		}

		try {
			RoomType filter = valueOf(s.toUpperCase());
			return filter;
		} catch (Exception e) {
			return CABIN;
		}
	}

	public String getDisplayString() {
		return displayString;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

	public static boolean match(String src, RoomType target) {
		RoomType roomType = RoomType.fromString(src);
		return target == roomType;
	}
}
