package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MENU_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENU_ITEM"
 */

public abstract class BaseMenuItem  implements Comparable, Serializable {

	public static String REF = "MenuItem"; //$NON-NLS-1$
	public static String PROP_SHOW_IMAGE_ONLY = "showImageOnly"; //$NON-NLS-1$
	public static String PROP_AVG_COST = "avgCost"; //$NON-NLS-1$
	public static String PROP_SHOULD_PRINT_TO_KITCHEN = "shouldPrintToKitchen"; //$NON-NLS-1$
	public static String PROP_TAX_ON_SERVICE_CHARGE = "taxOnServiceCharge"; //$NON-NLS-1$
	public static String PROP_MENU_CATEGORY_NAME = "menuCategoryName"; //$NON-NLS-1$
	public static String PROP_CAN_BE_SHIPPED = "canBeShipped"; //$NON-NLS-1$
	public static String PROP_BRAND_ID = "brandId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_UNIT_ID = "unitId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$
	public static String PROP_SERVICE_TYPE = "serviceType"; //$NON-NLS-1$
	public static String PROP_IMAGE_ID = "imageId"; //$NON-NLS-1$
	public static String PROP_BEVERAGE = "beverage"; //$NON-NLS-1$
	public static String PROP_HAS_MODIFIERS = "hasModifiers"; //$NON-NLS-1$
	public static String PROP_HAS_MANDATORY_MODIFIERS = "hasMandatoryModifiers"; //$NON-NLS-1$
	public static String PROP_SPECIMEN_ID = "specimenId"; //$NON-NLS-1$
	public static String PROP_PRINT_KITCHEN_STICKER = "printKitchenSticker"; //$NON-NLS-1$
	public static String PROP_CAN_BE_RENTED = "canBeRented"; //$NON-NLS-1$
	public static String PROP_AVERAGE_UNIT_PURCHASE_PRICE = "averageUnitPurchasePrice"; //$NON-NLS-1$
	public static String PROP_TAX_GROUP_ID = "taxGroupId"; //$NON-NLS-1$
	public static String PROP_EDITABLE_PRICE = "editablePrice"; //$NON-NLS-1$
	public static String PROP_PRODUCT_TYPE = "productType"; //$NON-NLS-1$
	public static String PROP_UNIT_NAME = "unitName"; //$NON-NLS-1$
	public static String PROP_REPORT_GROUP_ID = "reportGroupId"; //$NON-NLS-1$
	public static String PROP_DEFAULT_SELL_PORTION = "defaultSellPortion"; //$NON-NLS-1$
	public static String PROP_PRINTER_GROUP_ID = "printerGroupId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES_JSON = "propertiesJson"; //$NON-NLS-1$
	public static String PROP_DISABLE_WHEN_STOCK_AMOUNT_IS_ZERO = "disableWhenStockAmountIsZero"; //$NON-NLS-1$
	public static String PROP_COMBO_ITEM = "comboItem"; //$NON-NLS-1$
	public static String PROP_CAN_BE_PURCHASED = "canBePurchased"; //$NON-NLS-1$
	public static String PROP_TEXT_COLOR_CODE = "textColorCode"; //$NON-NLS-1$
	public static String PROP_VARIANT = "variant"; //$NON-NLS-1$
	public static String PROP_MENU_GROUP_ID = "menuGroupId"; //$NON-NLS-1$
	public static String PROP_MENU_GROUP_NAME = "menuGroupName"; //$NON-NLS-1$
	public static String PROP_PRICE = "price"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_BARCODE = "barcode"; //$NON-NLS-1$
	public static String PROP_FRACTIONAL_UNIT = "fractionalUnit"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_APPLICABLE = "discountApplicable"; //$NON-NLS-1$
	public static String PROP_DEFAULT_RECIPE_ID = "defaultRecipeId"; //$NON-NLS-1$
	public static String PROP_HAS_VARIANT = "hasVariant"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_CAN_BE_DOWNLOADED = "canBeDownloaded"; //$NON-NLS-1$
	public static String PROP_DIGITAL_PRODUCT = "digitalProduct"; //$NON-NLS-1$
	public static String PROP_BUTTON_COLOR_CODE = "buttonColorCode"; //$NON-NLS-1$
	public static String PROP_INVENTORY_ITEM = "inventoryItem"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_MENU_CATEGORY_ID = "menuCategoryId"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_REFUNDABLE = "serviceChargeRefundable"; //$NON-NLS-1$
	public static String PROP_DOSAGE_FORMS_ID = "dosageFormsId"; //$NON-NLS-1$
	public static String PROP_MED_GENERIC_ID = "medGenericId"; //$NON-NLS-1$
	public static String PROP_FEATURED = "featured"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_REORDER_LEVEL = "reorderLevel"; //$NON-NLS-1$
	public static String PROP_COST = "cost"; //$NON-NLS-1$
	public static String PROP_RECURRING = "recurring"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE = "serviceCharge"; //$NON-NLS-1$
	public static String PROP_COURSE_ID = "courseId"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_VISIBLE = "visible"; //$NON-NLS-1$
	public static String PROP_MANUFACTURE_ID = "manufactureId"; //$NON-NLS-1$
	public static String PROP_ENABLE = "enable"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_RAW_MATERIAL = "rawMaterial"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_APPLICABLE = "serviceChargeApplicable"; //$NON-NLS-1$
	public static String PROP_PIZZA_TYPE = "pizzaType"; //$NON-NLS-1$
	public static String PROP_SERVICE = "service"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_TICKET_DISCOUNT_APPLICABLE = "ticketDiscountApplicable"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_RATE = "discountRate"; //$NON-NLS-1$
	public static String PROP_PARENT_MENU_ITEM_ID = "parentMenuItemId"; //$NON-NLS-1$
	public static String PROP_LAST_PURCHASED_COST = "lastPurchasedCost"; //$NON-NLS-1$
	public static String PROP_REPLENISH_LEVEL = "replenishLevel"; //$NON-NLS-1$
	public static String PROP_CAN_BE_SOLD = "canBeSold"; //$NON-NLS-1$
	public static String PROP_SHORT_ID = "shortId"; //$NON-NLS-1$
	public static String PROP_SKU = "sku"; //$NON-NLS-1$
	public static String PROP_ENABLE_ONLINE_ORDERING = "enableOnlineOrdering"; //$NON-NLS-1$


	// constructors
	public BaseMenuItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseMenuItem (
		java.lang.String id,
		java.lang.String name,
		java.lang.Double price) {

		this.setId(id);
		this.setName(name);
		this.setPrice(price);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String shortId;
				private java.lang.String name;
				private java.lang.String description;
				private java.lang.String unitName;
				private java.lang.String translatedName;
				private java.lang.String barcode;
				private java.lang.String sku;
				private java.lang.String brandId;
				private java.lang.String manufactureId;
				private java.lang.String dosageFormsId;
				private java.lang.String medGenericId;
				private java.lang.Double price;
				private java.lang.Double cost;
				private java.lang.Double discountRate;
				private java.lang.Boolean visible;
				private java.lang.Boolean beverage;
				private java.lang.Boolean enable;
				private java.lang.Boolean rawMaterial;
				private java.lang.Boolean inventoryItem;
				private java.lang.Double averageUnitPurchasePrice;
				private java.lang.Double reorderLevel;
				private java.lang.Double replenishLevel;
				private java.lang.Boolean disableWhenStockAmountIsZero;
				private java.lang.Boolean shouldPrintToKitchen;
				private java.lang.Boolean printKitchenSticker;
				private java.lang.Boolean hasVariant;
				private java.lang.Boolean variant;
				private java.lang.Boolean service;
				private java.lang.String serviceType;
				private java.lang.Boolean canBeSold;
				private java.lang.Boolean canBePurchased;
				private java.lang.Boolean recurring;
				private java.lang.Boolean canBeRented;
				private java.lang.Boolean digitalProduct;
				private java.lang.Boolean canBeDownloaded;
				private java.lang.Boolean canBeShipped;
				private java.lang.Boolean comboItem;
				private java.lang.Integer sortOrder;
				private java.lang.Integer buttonColorCode;
				private java.lang.Integer textColorCode;
				private java.lang.String productType;
				private java.lang.String imageId;
				private java.lang.Boolean showImageOnly;
				private java.lang.Boolean fractionalUnit;
				private java.lang.Boolean pizzaType;
				private java.lang.Integer defaultSellPortion;
				private java.lang.Double lastPurchasedCost;
				private java.lang.Double avgCost;
				private java.lang.Double serviceCharge;
				private java.lang.Boolean serviceChargeApplicable;
				private java.lang.Boolean taxOnServiceCharge;
				private java.lang.Boolean discountApplicable;
				private java.lang.Boolean ticketDiscountApplicable;
				private java.lang.Boolean serviceChargeRefundable;
				private java.lang.String menuGroupId;
				private java.lang.String menuGroupName;
				private java.lang.String menuCategoryId;
				private java.lang.String menuCategoryName;
				private java.lang.String specimenId;
				private java.lang.String courseId;
				private java.lang.String unitId;
				private java.lang.String taxGroupId;
				private java.lang.String printerGroupId;
				private java.lang.String reportGroupId;
				private java.lang.String parentMenuItemId;
				private java.lang.Boolean hasModifiers;
				private java.lang.Boolean hasMandatoryModifiers;
				private java.lang.String propertiesJson;
				private java.lang.String defaultRecipeId;
				private java.lang.Boolean editablePrice;
				private java.lang.Boolean featured;
				private java.lang.Boolean enableOnlineOrdering;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.List<com.floreantpos.model.Attribute> attributes;
	private java.util.List<com.floreantpos.model.Discount> discounts;
	private java.util.List<com.floreantpos.model.MenuItemModifierSpec> menuItemModiferSpecs;
	private java.util.List<com.floreantpos.model.ComboGroup> comboGroups;
	private java.util.List<com.floreantpos.model.ComboItem> comboItems;
	private java.util.List<com.floreantpos.model.InventoryStockUnit> stockUnits;
	private java.util.List<com.floreantpos.model.PizzaPrice> pizzaPriceList;
	private java.util.List<com.floreantpos.model.MenuItem> variants;
	private java.util.List<com.floreantpos.model.TestItem> testItems;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.NameBaseIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: SHORT_ID
	 */

	public java.lang.String getShortId () {
			return shortId;
	}



	/**
	 * Set the value related to the column: SHORT_ID
	 * @param shortId the SHORT_ID value
	 */
			public void setShortId (java.lang.String shortId) {
			this.shortId = shortId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: UNIT_NAME
	 */

	public java.lang.String getUnitName () {
			return unitName;
	}



	/**
	 * Set the value related to the column: UNIT_NAME
	 * @param unitName the UNIT_NAME value
	 */
			public void setUnitName (java.lang.String unitName) {
			this.unitName = unitName;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName () {
			return translatedName;
	}



	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: BARCODE
	 */

	public java.lang.String getBarcode () {
			return barcode;
	}



	/**
	 * Set the value related to the column: BARCODE
	 * @param barcode the BARCODE value
	 */
			public void setBarcode (java.lang.String barcode) {
			this.barcode = barcode;
	}



	/**
	 * Return the value associated with the column: SKU
	 */

	public java.lang.String getSku () {
			return sku;
	}



	/**
	 * Set the value related to the column: SKU
	 * @param sku the SKU value
	 */
			public void setSku (java.lang.String sku) {
			this.sku = sku;
	}



	/**
	 * Return the value associated with the column: BRAND_ID
	 */

	public java.lang.String getBrandId () {
			return brandId;
	}



	/**
	 * Set the value related to the column: BRAND_ID
	 * @param brandId the BRAND_ID value
	 */
			public void setBrandId (java.lang.String brandId) {
			this.brandId = brandId;
	}



	/**
	 * Return the value associated with the column: MANUFACTURE_ID
	 */

	public java.lang.String getManufactureId () {
			return manufactureId;
	}



	/**
	 * Set the value related to the column: MANUFACTURE_ID
	 * @param manufactureId the MANUFACTURE_ID value
	 */
			public void setManufactureId (java.lang.String manufactureId) {
			this.manufactureId = manufactureId;
	}



	/**
	 * Return the value associated with the column: DOSAGE_FORMS_ID
	 */

	public java.lang.String getDosageFormsId () {
			return dosageFormsId;
	}



	/**
	 * Set the value related to the column: DOSAGE_FORMS_ID
	 * @param dosageFormsId the DOSAGE_FORMS_ID value
	 */
			public void setDosageFormsId (java.lang.String dosageFormsId) {
			this.dosageFormsId = dosageFormsId;
	}

	/**
	 * Return the value associated with the column: MED_GENERIC_ID
	 */

	public java.lang.String getMedGenericId () {
			return medGenericId;
	}



	/**
	 * Set the value related to the column: MED_GENERIC_ID
	 * @param medGenericId the MED_GENERIC_ID value
	 */
			public void setMedGenericId (java.lang.String medGenericId) {
			this.medGenericId = medGenericId;
	}


	/**
	 * Return the value associated with the column: PRICE
	 */

	public java.lang.Double getPrice () {
						return price == null ? Double.valueOf(0) : price;
		}



	/**
	 * Set the value related to the column: PRICE
	 * @param price the PRICE value
	 */
			public void setPrice (java.lang.Double price) {
			this.price = price;
	}



	/**
	 * Return the value associated with the column: COST
	 */

	public java.lang.Double getCost () {
						return cost == null ? Double.valueOf(0) : cost;
		}



	/**
	 * Set the value related to the column: COST
	 * @param cost the COST value
	 */
			public void setCost (java.lang.Double cost) {
			this.cost = cost;
	}



	/**
	 * Return the value associated with the column: DISCOUNT_RATE
	 */

	public java.lang.Double getDiscountRate () {
						return discountRate == null ? Double.valueOf(0) : discountRate;
		}



	/**
	 * Set the value related to the column: DISCOUNT_RATE
	 * @param discountRate the DISCOUNT_RATE value
	 */
			public void setDiscountRate (java.lang.Double discountRate) {
			this.discountRate = discountRate;
	}



	/**
	 * Return the value associated with the column: VISIBLE
	 */

	public java.lang.Boolean isVisible () {
						return visible == null ? Boolean.valueOf(true) : visible;
			}

	public java.lang.Boolean getVisible () {
					return visible == null ? Boolean.valueOf(true) : visible;
			}


	/**
	 * Set the value related to the column: VISIBLE
	 * @param visible the VISIBLE value
	 */
			public void setVisible (java.lang.Boolean visible) {
			this.visible = visible;
	}


	/**
	 * Custom property
	 */
	public static String getVisibleDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: BEVERAGE
	 */

	public java.lang.Boolean isBeverage () {
					return beverage == null ? Boolean.FALSE : beverage;
		}

	public java.lang.Boolean getBeverage () {
				return beverage == null ? Boolean.FALSE : beverage;
			}


	/**
	 * Set the value related to the column: BEVERAGE
	 * @param beverage the BEVERAGE value
	 */
			public void setBeverage (java.lang.Boolean beverage) {
			this.beverage = beverage;
	}



	/**
	 * Return the value associated with the column: ENABLE
	 */

	public java.lang.Boolean isEnable () {
						return enable == null ? Boolean.valueOf(true) : enable;
			}

	public java.lang.Boolean getEnable () {
					return enable == null ? Boolean.valueOf(true) : enable;
			}


	/**
	 * Set the value related to the column: ENABLE
	 * @param enable the ENABLE value
	 */
			public void setEnable (java.lang.Boolean enable) {
			this.enable = enable;
	}


	/**
	 * Custom property
	 */
	public static String getEnableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: RAW_MATERIAL
	 */

	public java.lang.Boolean isRawMaterial () {
					return rawMaterial == null ? Boolean.FALSE : rawMaterial;
		}

	public java.lang.Boolean getRawMaterial () {
				return rawMaterial == null ? Boolean.FALSE : rawMaterial;
			}


	/**
	 * Set the value related to the column: RAW_MATERIAL
	 * @param rawMaterial the RAW_MATERIAL value
	 */
			public void setRawMaterial (java.lang.Boolean rawMaterial) {
			this.rawMaterial = rawMaterial;
	}



	/**
	 * Return the value associated with the column: INVENTORY
	 */

	public java.lang.Boolean isInventoryItem () {
						return inventoryItem == null ? Boolean.valueOf(true) : inventoryItem;
			}

	public java.lang.Boolean getInventoryItem () {
					return inventoryItem == null ? Boolean.valueOf(true) : inventoryItem;
			}


	/**
	 * Set the value related to the column: INVENTORY
	 * @param inventoryItem the INVENTORY value
	 */
			public void setInventoryItem (java.lang.Boolean inventoryItem) {
			this.inventoryItem = inventoryItem;
	}


	/**
	 * Custom property
	 */
	public static String getInventoryItemDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: AVG_UNIT_PURCHASE_PRICE
	 */

	public java.lang.Double getAverageUnitPurchasePrice () {
						return averageUnitPurchasePrice == null ? Double.valueOf(0) : averageUnitPurchasePrice;
		}



	/**
	 * Set the value related to the column: AVG_UNIT_PURCHASE_PRICE
	 * @param averageUnitPurchasePrice the AVG_UNIT_PURCHASE_PRICE value
	 */
			public void setAverageUnitPurchasePrice (java.lang.Double averageUnitPurchasePrice) {
			this.averageUnitPurchasePrice = averageUnitPurchasePrice;
	}



	/**
	 * Return the value associated with the column: REORDER_LEVEL
	 */

	public java.lang.Double getReorderLevel () {
						return reorderLevel == null ? Double.valueOf(0) : reorderLevel;
		}



	/**
	 * Set the value related to the column: REORDER_LEVEL
	 * @param reorderLevel the REORDER_LEVEL value
	 */
			public void setReorderLevel (java.lang.Double reorderLevel) {
			this.reorderLevel = reorderLevel;
	}



	/**
	 * Return the value associated with the column: REPLENISH_LEVEL
	 */

	public java.lang.Double getReplenishLevel () {
						return replenishLevel == null ? Double.valueOf(0) : replenishLevel;
		}



	/**
	 * Set the value related to the column: REPLENISH_LEVEL
	 * @param replenishLevel the REPLENISH_LEVEL value
	 */
			public void setReplenishLevel (java.lang.Double replenishLevel) {
			this.replenishLevel = replenishLevel;
	}



	/**
	 * Return the value associated with the column: DISABLE_WHEN_STOCK_AMOUNT_IS_ZERO
	 */

	public java.lang.Boolean isDisableWhenStockAmountIsZero () {
						return disableWhenStockAmountIsZero == null ? Boolean.valueOf(false) : disableWhenStockAmountIsZero;
			}

	public java.lang.Boolean getDisableWhenStockAmountIsZero () {
					return disableWhenStockAmountIsZero == null ? Boolean.valueOf(false) : disableWhenStockAmountIsZero;
			}


	/**
	 * Set the value related to the column: DISABLE_WHEN_STOCK_AMOUNT_IS_ZERO
	 * @param disableWhenStockAmountIsZero the DISABLE_WHEN_STOCK_AMOUNT_IS_ZERO value
	 */
			public void setDisableWhenStockAmountIsZero (java.lang.Boolean disableWhenStockAmountIsZero) {
			this.disableWhenStockAmountIsZero = disableWhenStockAmountIsZero;
	}


	/**
	 * Custom property
	 */
	public static String getDisableWhenStockAmountIsZeroDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PRINT_TO_KITCHEN
	 */

	public java.lang.Boolean isShouldPrintToKitchen () {
						return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}

	public java.lang.Boolean getShouldPrintToKitchen () {
					return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}


	/**
	 * Set the value related to the column: PRINT_TO_KITCHEN
	 * @param shouldPrintToKitchen the PRINT_TO_KITCHEN value
	 */
			public void setShouldPrintToKitchen (java.lang.Boolean shouldPrintToKitchen) {
			this.shouldPrintToKitchen = shouldPrintToKitchen;
	}


	/**
	 * Custom property
	 */
	public static String getShouldPrintToKitchenDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: PRINT_KITCHEN_STICKER
	 */

	public java.lang.Boolean isPrintKitchenSticker () {
						return printKitchenSticker == null ? Boolean.valueOf(false) : printKitchenSticker;
			}

	public java.lang.Boolean getPrintKitchenSticker () {
					return printKitchenSticker == null ? Boolean.valueOf(false) : printKitchenSticker;
			}


	/**
	 * Set the value related to the column: PRINT_KITCHEN_STICKER
	 * @param printKitchenSticker the PRINT_KITCHEN_STICKER value
	 */
			public void setPrintKitchenSticker (java.lang.Boolean printKitchenSticker) {
			this.printKitchenSticker = printKitchenSticker;
	}


	/**
	 * Custom property
	 */
	public static String getPrintKitchenStickerDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: HAS_VARIANT
	 */

	public java.lang.Boolean isHasVariant () {
					return hasVariant == null ? Boolean.FALSE : hasVariant;
		}

	public java.lang.Boolean getHasVariant () {
				return hasVariant == null ? Boolean.FALSE : hasVariant;
			}


	/**
	 * Set the value related to the column: HAS_VARIANT
	 * @param hasVariant the HAS_VARIANT value
	 */
			public void setHasVariant (java.lang.Boolean hasVariant) {
			this.hasVariant = hasVariant;
	}



	/**
	 * Return the value associated with the column: IS_VARIANT
	 */

	public java.lang.Boolean isVariant () {
					return variant == null ? Boolean.FALSE : variant;
		}

	public java.lang.Boolean getVariant () {
				return variant == null ? Boolean.FALSE : variant;
			}


	/**
	 * Set the value related to the column: IS_VARIANT
	 * @param variant the IS_VARIANT value
	 */
			public void setVariant (java.lang.Boolean variant) {
			this.variant = variant;
	}



	/**
	 * Return the value associated with the column: IS_SERVICE
	 */

	public java.lang.Boolean isService () {
					return service == null ? Boolean.FALSE : service;
		}

	public java.lang.Boolean getService () {
				return service == null ? Boolean.FALSE : service;
			}


	/**
	 * Set the value related to the column: IS_SERVICE
	 * @param service the IS_SERVICE value
	 */
			public void setService (java.lang.Boolean service) {
			this.service = service;
	}



	/**
	 * Return the value associated with the column: SERVICE_TYPE
	 */

	public java.lang.String getServiceType () {
			return serviceType;
	}



	/**
	 * Set the value related to the column: SERVICE_TYPE
	 * @param serviceType the SERVICE_TYPE value
	 */
			public void setServiceType (java.lang.String serviceType) {
			this.serviceType = serviceType;
	}



	/**
	 * Return the value associated with the column: CAN_BE_SOLD
	 */

	public java.lang.Boolean isCanBeSold () {
						return canBeSold == null ? Boolean.valueOf(true) : canBeSold;
			}

	public java.lang.Boolean getCanBeSold () {
					return canBeSold == null ? Boolean.valueOf(true) : canBeSold;
			}


	/**
	 * Set the value related to the column: CAN_BE_SOLD
	 * @param canBeSold the CAN_BE_SOLD value
	 */
			public void setCanBeSold (java.lang.Boolean canBeSold) {
			this.canBeSold = canBeSold;
	}


	/**
	 * Custom property
	 */
	public static String getCanBeSoldDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: CAN_BE_PURCHASED
	 */

	public java.lang.Boolean isCanBePurchased () {
						return canBePurchased == null ? Boolean.valueOf(true) : canBePurchased;
			}

	public java.lang.Boolean getCanBePurchased () {
					return canBePurchased == null ? Boolean.valueOf(true) : canBePurchased;
			}


	/**
	 * Set the value related to the column: CAN_BE_PURCHASED
	 * @param canBePurchased the CAN_BE_PURCHASED value
	 */
			public void setCanBePurchased (java.lang.Boolean canBePurchased) {
			this.canBePurchased = canBePurchased;
	}


	/**
	 * Custom property
	 */
	public static String getCanBePurchasedDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: RECURRING
	 */

	public java.lang.Boolean isRecurring () {
						return recurring == null ? Boolean.valueOf(false) : recurring;
			}

	public java.lang.Boolean getRecurring () {
					return recurring == null ? Boolean.valueOf(false) : recurring;
			}


	/**
	 * Set the value related to the column: RECURRING
	 * @param recurring the RECURRING value
	 */
			public void setRecurring (java.lang.Boolean recurring) {
			this.recurring = recurring;
	}


	/**
	 * Custom property
	 */
	public static String getRecurringDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: CAN_BE_RENTED
	 */

	public java.lang.Boolean isCanBeRented () {
						return canBeRented == null ? Boolean.valueOf(false) : canBeRented;
			}

	public java.lang.Boolean getCanBeRented () {
					return canBeRented == null ? Boolean.valueOf(false) : canBeRented;
			}


	/**
	 * Set the value related to the column: CAN_BE_RENTED
	 * @param canBeRented the CAN_BE_RENTED value
	 */
			public void setCanBeRented (java.lang.Boolean canBeRented) {
			this.canBeRented = canBeRented;
	}


	/**
	 * Custom property
	 */
	public static String getCanBeRentedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: DIGITAL_PRODUCT
	 */

	public java.lang.Boolean isDigitalProduct () {
						return digitalProduct == null ? Boolean.valueOf(false) : digitalProduct;
			}

	public java.lang.Boolean getDigitalProduct () {
					return digitalProduct == null ? Boolean.valueOf(false) : digitalProduct;
			}


	/**
	 * Set the value related to the column: DIGITAL_PRODUCT
	 * @param digitalProduct the DIGITAL_PRODUCT value
	 */
			public void setDigitalProduct (java.lang.Boolean digitalProduct) {
			this.digitalProduct = digitalProduct;
	}


	/**
	 * Custom property
	 */
	public static String getDigitalProductDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: CAN_BE_DOWNLOADED
	 */

	public java.lang.Boolean isCanBeDownloaded () {
						return canBeDownloaded == null ? Boolean.valueOf(false) : canBeDownloaded;
			}

	public java.lang.Boolean getCanBeDownloaded () {
					return canBeDownloaded == null ? Boolean.valueOf(false) : canBeDownloaded;
			}


	/**
	 * Set the value related to the column: CAN_BE_DOWNLOADED
	 * @param canBeDownloaded the CAN_BE_DOWNLOADED value
	 */
			public void setCanBeDownloaded (java.lang.Boolean canBeDownloaded) {
			this.canBeDownloaded = canBeDownloaded;
	}


	/**
	 * Custom property
	 */
	public static String getCanBeDownloadedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: CAN_BE_SHIPPED
	 */

	public java.lang.Boolean isCanBeShipped () {
						return canBeShipped == null ? Boolean.valueOf(true) : canBeShipped;
			}

	public java.lang.Boolean getCanBeShipped () {
					return canBeShipped == null ? Boolean.valueOf(true) : canBeShipped;
			}


	/**
	 * Set the value related to the column: CAN_BE_SHIPPED
	 * @param canBeShipped the CAN_BE_SHIPPED value
	 */
			public void setCanBeShipped (java.lang.Boolean canBeShipped) {
			this.canBeShipped = canBeShipped;
	}


	/**
	 * Custom property
	 */
	public static String getCanBeShippedDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: ComboItem
	 */

	public java.lang.Boolean isComboItem () {
					return comboItem == null ? Boolean.FALSE : comboItem;
		}

	public java.lang.Boolean getComboItem () {
				return comboItem == null ? Boolean.FALSE : comboItem;
			}


	/**
	 * Set the value related to the column: ComboItem
	 * @param comboItem the ComboItem value
	 */
			public void setComboItem (java.lang.Boolean comboItem) {
			this.comboItem = comboItem;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: BTN_COLOR
	 */

	public java.lang.Integer getButtonColorCode () {
						return buttonColorCode == null ? null : buttonColorCode;
			}



	/**
	 * Set the value related to the column: BTN_COLOR
	 * @param buttonColorCode the BTN_COLOR value
	 */
			public void setButtonColorCode (java.lang.Integer buttonColorCode) {
			this.buttonColorCode = buttonColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getButtonColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: TEXT_COLOR
	 */

	public java.lang.Integer getTextColorCode () {
						return textColorCode == null ? null : textColorCode;
			}



	/**
	 * Set the value related to the column: TEXT_COLOR
	 * @param textColorCode the TEXT_COLOR value
	 */
			public void setTextColorCode (java.lang.Integer textColorCode) {
			this.textColorCode = textColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getTextColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: PRODUCT_TYPE
	 */

	public java.lang.String getProductType () {
			return productType;
	}



	/**
	 * Set the value related to the column: PRODUCT_TYPE
	 * @param productType the PRODUCT_TYPE value
	 */
			public void setProductType (java.lang.String productType) {
			this.productType = productType;
	}



	/**
	 * Return the value associated with the column: IMAGE_ID
	 */

	public java.lang.String getImageId () {
			return imageId;
	}



	/**
	 * Set the value related to the column: IMAGE_ID
	 * @param imageId the IMAGE_ID value
	 */
			public void setImageId (java.lang.String imageId) {
			this.imageId = imageId;
	}



	/**
	 * Return the value associated with the column: SHOW_IMAGE_ONLY
	 */

	public java.lang.Boolean isShowImageOnly () {
					return showImageOnly == null ? Boolean.FALSE : showImageOnly;
		}

	public java.lang.Boolean getShowImageOnly () {
				return showImageOnly == null ? Boolean.FALSE : showImageOnly;
			}


	/**
	 * Set the value related to the column: SHOW_IMAGE_ONLY
	 * @param showImageOnly the SHOW_IMAGE_ONLY value
	 */
			public void setShowImageOnly (java.lang.Boolean showImageOnly) {
			this.showImageOnly = showImageOnly;
	}



	/**
	 * Return the value associated with the column: FRACTIONAL_UNIT
	 */

	public java.lang.Boolean isFractionalUnit () {
					return fractionalUnit == null ? Boolean.FALSE : fractionalUnit;
		}

	public java.lang.Boolean getFractionalUnit () {
				return fractionalUnit == null ? Boolean.FALSE : fractionalUnit;
			}


	/**
	 * Set the value related to the column: FRACTIONAL_UNIT
	 * @param fractionalUnit the FRACTIONAL_UNIT value
	 */
			public void setFractionalUnit (java.lang.Boolean fractionalUnit) {
			this.fractionalUnit = fractionalUnit;
	}



	/**
	 * Return the value associated with the column: PIZZA_TYPE
	 */

	public java.lang.Boolean isPizzaType () {
					return pizzaType == null ? Boolean.FALSE : pizzaType;
		}

	public java.lang.Boolean getPizzaType () {
				return pizzaType == null ? Boolean.FALSE : pizzaType;
			}


	/**
	 * Set the value related to the column: PIZZA_TYPE
	 * @param pizzaType the PIZZA_TYPE value
	 */
			public void setPizzaType (java.lang.Boolean pizzaType) {
			this.pizzaType = pizzaType;
	}



	/**
	 * Return the value associated with the column: DEFAULT_SELL_PORTION
	 */

	public java.lang.Integer getDefaultSellPortion () {
						return defaultSellPortion == null ? Integer.valueOf(0) : defaultSellPortion;
		}



	/**
	 * Set the value related to the column: DEFAULT_SELL_PORTION
	 * @param defaultSellPortion the DEFAULT_SELL_PORTION value
	 */
			public void setDefaultSellPortion (java.lang.Integer defaultSellPortion) {
			this.defaultSellPortion = defaultSellPortion;
	}



	/**
	 * Return the value associated with the column: LAST_PURCHASE_COST
	 */

	public java.lang.Double getLastPurchasedCost () {
						return lastPurchasedCost == null ? Double.valueOf(0) : lastPurchasedCost;
		}



	/**
	 * Set the value related to the column: LAST_PURCHASE_COST
	 * @param lastPurchasedCost the LAST_PURCHASE_COST value
	 */
			public void setLastPurchasedCost (java.lang.Double lastPurchasedCost) {
			this.lastPurchasedCost = lastPurchasedCost;
	}



	/**
	 * Return the value associated with the column: AVG_COST
	 */

	public java.lang.Double getAvgCost () {
						return avgCost == null ? Double.valueOf(0) : avgCost;
		}



	/**
	 * Set the value related to the column: AVG_COST
	 * @param avgCost the AVG_COST value
	 */
			public void setAvgCost (java.lang.Double avgCost) {
			this.avgCost = avgCost;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE
	 */

	public java.lang.Double getServiceCharge () {
						return serviceCharge == null ? Double.valueOf(0) : serviceCharge;
		}



	/**
	 * Set the value related to the column: SERVICE_CHARGE
	 * @param serviceCharge the SERVICE_CHARGE value
	 */
			public void setServiceCharge (java.lang.Double serviceCharge) {
			this.serviceCharge = serviceCharge;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE_APPLICABLE
	 */

	public java.lang.Boolean isServiceChargeApplicable () {
						return serviceChargeApplicable == null ? Boolean.valueOf(true) : serviceChargeApplicable;
			}

	public java.lang.Boolean getServiceChargeApplicable () {
					return serviceChargeApplicable == null ? Boolean.valueOf(true) : serviceChargeApplicable;
			}


	/**
	 * Set the value related to the column: SERVICE_CHARGE_APPLICABLE
	 * @param serviceChargeApplicable the SERVICE_CHARGE_APPLICABLE value
	 */
			public void setServiceChargeApplicable (java.lang.Boolean serviceChargeApplicable) {
			this.serviceChargeApplicable = serviceChargeApplicable;
	}


	/**
	 * Custom property
	 */
	public static String getServiceChargeApplicableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: TAX_ON_SERVICE_CHARGE
	 */

	public java.lang.Boolean isTaxOnServiceCharge () {
					return taxOnServiceCharge == null ? Boolean.FALSE : taxOnServiceCharge;
		}

	public java.lang.Boolean getTaxOnServiceCharge () {
				return taxOnServiceCharge == null ? Boolean.FALSE : taxOnServiceCharge;
			}


	/**
	 * Set the value related to the column: TAX_ON_SERVICE_CHARGE
	 * @param taxOnServiceCharge the TAX_ON_SERVICE_CHARGE value
	 */
			public void setTaxOnServiceCharge (java.lang.Boolean taxOnServiceCharge) {
			this.taxOnServiceCharge = taxOnServiceCharge;
	}



	/**
	 * Return the value associated with the column: DISCOUNT_APPLICABLE
	 */

	public java.lang.Boolean isDiscountApplicable () {
						return discountApplicable == null ? Boolean.valueOf(true) : discountApplicable;
			}

	public java.lang.Boolean getDiscountApplicable () {
					return discountApplicable == null ? Boolean.valueOf(true) : discountApplicable;
			}


	/**
	 * Set the value related to the column: DISCOUNT_APPLICABLE
	 * @param discountApplicable the DISCOUNT_APPLICABLE value
	 */
			public void setDiscountApplicable (java.lang.Boolean discountApplicable) {
			this.discountApplicable = discountApplicable;
	}


	/**
	 * Custom property
	 */
	public static String getDiscountApplicableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: TICKET_DISCOUNT_APPLICABLE
	 */

	public java.lang.Boolean isTicketDiscountApplicable () {
						return ticketDiscountApplicable == null ? Boolean.valueOf(true) : ticketDiscountApplicable;
			}

	public java.lang.Boolean getTicketDiscountApplicable () {
					return ticketDiscountApplicable == null ? Boolean.valueOf(true) : ticketDiscountApplicable;
			}


	/**
	 * Set the value related to the column: TICKET_DISCOUNT_APPLICABLE
	 * @param ticketDiscountApplicable the TICKET_DISCOUNT_APPLICABLE value
	 */
			public void setTicketDiscountApplicable (java.lang.Boolean ticketDiscountApplicable) {
			this.ticketDiscountApplicable = ticketDiscountApplicable;
	}


	/**
	 * Custom property
	 */
	public static String getTicketDiscountApplicableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: SERVICE_CHARGE_REFUNDABLE
	 */

	public java.lang.Boolean isServiceChargeRefundable () {
						return serviceChargeRefundable == null ? Boolean.valueOf(true) : serviceChargeRefundable;
			}

	public java.lang.Boolean getServiceChargeRefundable () {
					return serviceChargeRefundable == null ? Boolean.valueOf(true) : serviceChargeRefundable;
			}


	/**
	 * Set the value related to the column: SERVICE_CHARGE_REFUNDABLE
	 * @param serviceChargeRefundable the SERVICE_CHARGE_REFUNDABLE value
	 */
			public void setServiceChargeRefundable (java.lang.Boolean serviceChargeRefundable) {
			this.serviceChargeRefundable = serviceChargeRefundable;
	}


	/**
	 * Custom property
	 */
	public static String getServiceChargeRefundableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: GROUP_ID
	 */

	public java.lang.String getMenuGroupId () {
			return menuGroupId;
	}



	/**
	 * Set the value related to the column: GROUP_ID
	 * @param menuGroupId the GROUP_ID value
	 */
			public void setMenuGroupId (java.lang.String menuGroupId) {
			this.menuGroupId = menuGroupId;
	}



	/**
	 * Return the value associated with the column: GROUP_NAME
	 */

	public java.lang.String getMenuGroupName () {
			return menuGroupName;
	}



	/**
	 * Set the value related to the column: GROUP_NAME
	 * @param menuGroupName the GROUP_NAME value
	 */
			public void setMenuGroupName (java.lang.String menuGroupName) {
			this.menuGroupName = menuGroupName;
	}



	/**
	 * Return the value associated with the column: CATEGORY_ID
	 */

	public java.lang.String getMenuCategoryId () {
			return menuCategoryId;
	}



	/**
	 * Set the value related to the column: CATEGORY_ID
	 * @param menuCategoryId the CATEGORY_ID value
	 */
			public void setMenuCategoryId (java.lang.String menuCategoryId) {
			this.menuCategoryId = menuCategoryId;
	}



	/**
	 * Return the value associated with the column: CATEGORY_NAME
	 */

	public java.lang.String getMenuCategoryName () {
			return menuCategoryName;
	}



	/**
	 * Set the value related to the column: CATEGORY_NAME
	 * @param menuCategoryName the CATEGORY_NAME value
	 */
			public void setMenuCategoryName (java.lang.String menuCategoryName) {
			this.menuCategoryName = menuCategoryName;
	}



	/**
	 * Return the value associated with the column: SPECIMEN_ID
	 */

	public java.lang.String getSpecimenId () {
			return specimenId;
	}



	/**
	 * Set the value related to the column: SPECIMEN_ID
	 * @param specimenId the SPECIMEN_ID value
	 */
			public void setSpecimenId (java.lang.String specimenId) {
			this.specimenId = specimenId;
	}



	/**
	 * Return the value associated with the column: COURSE_ID
	 */

	public java.lang.String getCourseId () {
			return courseId;
	}



	/**
	 * Set the value related to the column: COURSE_ID
	 * @param courseId the COURSE_ID value
	 */
			public void setCourseId (java.lang.String courseId) {
			this.courseId = courseId;
	}



	/**
	 * Return the value associated with the column: UNIT_ID
	 */

	public java.lang.String getUnitId () {
			return unitId;
	}



	/**
	 * Set the value related to the column: UNIT_ID
	 * @param unitId the UNIT_ID value
	 */
			public void setUnitId (java.lang.String unitId) {
			this.unitId = unitId;
	}



	/**
	 * Return the value associated with the column: TAX_GROUP_ID
	 */

	public java.lang.String getTaxGroupId () {
			return taxGroupId;
	}



	/**
	 * Set the value related to the column: TAX_GROUP_ID
	 * @param taxGroupId the TAX_GROUP_ID value
	 */
			public void setTaxGroupId (java.lang.String taxGroupId) {
			this.taxGroupId = taxGroupId;
	}



	/**
	 * Return the value associated with the column: PG_ID
	 */

	public java.lang.String getPrinterGroupId () {
			return printerGroupId;
	}



	/**
	 * Set the value related to the column: PG_ID
	 * @param printerGroupId the PG_ID value
	 */
			public void setPrinterGroupId (java.lang.String printerGroupId) {
			this.printerGroupId = printerGroupId;
	}



	/**
	 * Return the value associated with the column: REPORT_GROUP_ID
	 */

	public java.lang.String getReportGroupId () {
			return reportGroupId;
	}



	/**
	 * Set the value related to the column: REPORT_GROUP_ID
	 * @param reportGroupId the REPORT_GROUP_ID value
	 */
			public void setReportGroupId (java.lang.String reportGroupId) {
			this.reportGroupId = reportGroupId;
	}



	/**
	 * Return the value associated with the column: PARENT_MENU_ITEM_ID
	 */

	public java.lang.String getParentMenuItemId () {
			return parentMenuItemId;
	}



	/**
	 * Set the value related to the column: PARENT_MENU_ITEM_ID
	 * @param parentMenuItemId the PARENT_MENU_ITEM_ID value
	 */
			public void setParentMenuItemId (java.lang.String parentMenuItemId) {
			this.parentMenuItemId = parentMenuItemId;
	}



	/**
	 * Return the value associated with the column: HAS_MODIFIERS
	 */

	public java.lang.Boolean isHasModifiers () {
					return hasModifiers == null ? Boolean.FALSE : hasModifiers;
		}

	public java.lang.Boolean getHasModifiers () {
				return hasModifiers == null ? Boolean.FALSE : hasModifiers;
			}


	/**
	 * Set the value related to the column: HAS_MODIFIERS
	 * @param hasModifiers the HAS_MODIFIERS value
	 */
			public void setHasModifiers (java.lang.Boolean hasModifiers) {
			this.hasModifiers = hasModifiers;
	}



	/**
	 * Return the value associated with the column: HAS_MANDATORY_MODIFIERS
	 */

	public java.lang.Boolean isHasMandatoryModifiers () {
					return hasMandatoryModifiers == null ? Boolean.FALSE : hasMandatoryModifiers;
		}

	public java.lang.Boolean getHasMandatoryModifiers () {
				return hasMandatoryModifiers == null ? Boolean.FALSE : hasMandatoryModifiers;
			}


	/**
	 * Set the value related to the column: HAS_MANDATORY_MODIFIERS
	 * @param hasMandatoryModifiers the HAS_MANDATORY_MODIFIERS value
	 */
			public void setHasMandatoryModifiers (java.lang.Boolean hasMandatoryModifiers) {
			this.hasMandatoryModifiers = hasMandatoryModifiers;
	}



	/**
	 * Return the value associated with the column: PROPERTIES_JSON
	 */

	public java.lang.String getPropertiesJson () {
			return propertiesJson;
	}



	/**
	 * Set the value related to the column: PROPERTIES_JSON
	 * @param propertiesJson the PROPERTIES_JSON value
	 */
			public void setPropertiesJson (java.lang.String propertiesJson) {
			this.propertiesJson = propertiesJson;
	}



	/**
	 * Return the value associated with the column: DEFAULT_RECIPE_ID
	 */

	public java.lang.String getDefaultRecipeId () {
			return defaultRecipeId;
	}



	/**
	 * Set the value related to the column: DEFAULT_RECIPE_ID
	 * @param defaultRecipeId the DEFAULT_RECIPE_ID value
	 */
			public void setDefaultRecipeId (java.lang.String defaultRecipeId) {
			this.defaultRecipeId = defaultRecipeId;
	}



	/**
	 * Return the value associated with the column: EDITABLE_PRICE
	 */

	public java.lang.Boolean isEditablePrice () {
					return editablePrice == null ? Boolean.FALSE : editablePrice;
		}

	public java.lang.Boolean getEditablePrice () {
				return editablePrice == null ? Boolean.FALSE : editablePrice;
			}


	/**
	 * Set the value related to the column: EDITABLE_PRICE
	 * @param editablePrice the EDITABLE_PRICE value
	 */
			public void setEditablePrice (java.lang.Boolean editablePrice) {
			this.editablePrice = editablePrice;
	}



	/**
	 * Return the value associated with the column: FEATURED
	 */

	public java.lang.Boolean isFeatured () {
					return featured == null ? Boolean.FALSE : featured;
		}

	public java.lang.Boolean getFeatured () {
				return featured == null ? Boolean.FALSE : featured;
			}


	/**
	 * Set the value related to the column: FEATURED
	 * @param featured the FEATURED value
	 */
			public void setFeatured (java.lang.Boolean featured) {
			this.featured = featured;
	}



	/**
	 * Return the value associated with the column: ENABLE_ONLINE_ORDERING
	 */

	public java.lang.Boolean isEnableOnlineOrdering () {
					return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
		}

	public java.lang.Boolean getEnableOnlineOrdering () {
				return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
			}


	/**
	 * Set the value related to the column: ENABLE_ONLINE_ORDERING
	 * @param enableOnlineOrdering the ENABLE_ONLINE_ORDERING value
	 */
			public void setEnableOnlineOrdering (java.lang.Boolean enableOnlineOrdering) {
			this.enableOnlineOrdering = enableOnlineOrdering;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: attributes
	 */

	public java.util.List<com.floreantpos.model.Attribute> getAttributes () {
			return attributes;
	}



	/**
	 * Set the value related to the column: attributes
	 * @param attributes the attributes value
	 */
			public void setAttributes (java.util.List<com.floreantpos.model.Attribute> attributes) {
			this.attributes = attributes;
	}

	public void addToattributes (com.floreantpos.model.Attribute attribute) {
		if (null == getAttributes()) setAttributes(new java.util.ArrayList<com.floreantpos.model.Attribute>());
		getAttributes().add(attribute);
	}



	/**
	 * Return the value associated with the column: discounts
	 */

	public java.util.List<com.floreantpos.model.Discount> getDiscounts () {
			return discounts;
	}



	/**
	 * Set the value related to the column: discounts
	 * @param discounts the discounts value
	 */
			public void setDiscounts (java.util.List<com.floreantpos.model.Discount> discounts) {
			this.discounts = discounts;
	}

	public void addTodiscounts (com.floreantpos.model.Discount discount) {
		if (null == getDiscounts()) setDiscounts(new java.util.ArrayList<com.floreantpos.model.Discount>());
		getDiscounts().add(discount);
	}



	/**
	 * Return the value associated with the column: menuItemModiferSpecs
	 */

	public java.util.List<com.floreantpos.model.MenuItemModifierSpec> getMenuItemModiferSpecs () {
			return menuItemModiferSpecs;
	}



	/**
	 * Set the value related to the column: menuItemModiferSpecs
	 * @param menuItemModiferSpecs the menuItemModiferSpecs value
	 */
			public void setMenuItemModiferSpecs (java.util.List<com.floreantpos.model.MenuItemModifierSpec> menuItemModiferSpecs) {
			this.menuItemModiferSpecs = menuItemModiferSpecs;
	}

	public void addTomenuItemModiferSpecs (com.floreantpos.model.MenuItemModifierSpec menuItemModifierSpec) {
		if (null == getMenuItemModiferSpecs()) setMenuItemModiferSpecs(new java.util.ArrayList<com.floreantpos.model.MenuItemModifierSpec>());
		getMenuItemModiferSpecs().add(menuItemModifierSpec);
	}



	/**
	 * Return the value associated with the column: comboGroups
	 */

	public java.util.List<com.floreantpos.model.ComboGroup> getComboGroups () {
			return comboGroups;
	}



	/**
	 * Set the value related to the column: comboGroups
	 * @param comboGroups the comboGroups value
	 */
			public void setComboGroups (java.util.List<com.floreantpos.model.ComboGroup> comboGroups) {
			this.comboGroups = comboGroups;
	}

	public void addTocomboGroups (com.floreantpos.model.ComboGroup comboGroup) {
		if (null == getComboGroups()) setComboGroups(new java.util.ArrayList<com.floreantpos.model.ComboGroup>());
		getComboGroups().add(comboGroup);
	}



	/**
	 * Return the value associated with the column: comboItems
	 */

	public java.util.List<com.floreantpos.model.ComboItem> getComboItems () {
			return comboItems;
	}



	/**
	 * Set the value related to the column: comboItems
	 * @param comboItems the comboItems value
	 */
			public void setComboItems (java.util.List<com.floreantpos.model.ComboItem> comboItems) {
			this.comboItems = comboItems;
	}

	public void addTocomboItems (com.floreantpos.model.ComboItem comboItem) {
		if (null == getComboItems()) setComboItems(new java.util.ArrayList<com.floreantpos.model.ComboItem>());
		getComboItems().add(comboItem);
	}



	/**
	 * Return the value associated with the column: stockUnits
	 */

	public java.util.List<com.floreantpos.model.InventoryStockUnit> getStockUnits () {
			return stockUnits;
	}



	/**
	 * Set the value related to the column: stockUnits
	 * @param stockUnits the stockUnits value
	 */
			public void setStockUnits (java.util.List<com.floreantpos.model.InventoryStockUnit> stockUnits) {
			this.stockUnits = stockUnits;
	}

	public void addTostockUnits (com.floreantpos.model.InventoryStockUnit inventoryStockUnit) {
		if (null == getStockUnits()) setStockUnits(new java.util.ArrayList<com.floreantpos.model.InventoryStockUnit>());
		getStockUnits().add(inventoryStockUnit);
	}



	/**
	 * Return the value associated with the column: pizzaPriceList
	 */

	public java.util.List<com.floreantpos.model.PizzaPrice> getPizzaPriceList () {
			return pizzaPriceList;
	}



	/**
	 * Set the value related to the column: pizzaPriceList
	 * @param pizzaPriceList the pizzaPriceList value
	 */
			public void setPizzaPriceList (java.util.List<com.floreantpos.model.PizzaPrice> pizzaPriceList) {
			this.pizzaPriceList = pizzaPriceList;
	}

	public void addTopizzaPriceList (com.floreantpos.model.PizzaPrice pizzaPrice) {
		if (null == getPizzaPriceList()) setPizzaPriceList(new java.util.ArrayList<com.floreantpos.model.PizzaPrice>());
		getPizzaPriceList().add(pizzaPrice);
	}



	/**
	 * Return the value associated with the column: variants
	 */

	public java.util.List<com.floreantpos.model.MenuItem> getVariants () {
			return variants;
	}



	/**
	 * Set the value related to the column: variants
	 * @param variants the variants value
	 */
			public void setVariants (java.util.List<com.floreantpos.model.MenuItem> variants) {
			this.variants = variants;
	}

	public void addTovariants (com.floreantpos.model.MenuItem menuItem) {
		if (null == getVariants()) setVariants(new java.util.ArrayList<com.floreantpos.model.MenuItem>());
		getVariants().add(menuItem);
	}



	/**
	 * Return the value associated with the column: testItems
	 */

	public java.util.List<com.floreantpos.model.TestItem> getTestItems () {
			return testItems;
	}



	/**
	 * Set the value related to the column: testItems
	 * @param testItems the testItems value
	 */
			public void setTestItems (java.util.List<com.floreantpos.model.TestItem> testItems) {
			this.testItems = testItems;
	}

	public void addTotestItems (com.floreantpos.model.TestItem testItem) {
		if (null == getTestItems()) setTestItems(new java.util.ArrayList<com.floreantpos.model.TestItem>());
		getTestItems().add(testItem);
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuItem)) return false;
		else {
			com.floreantpos.model.MenuItem menuItem = (com.floreantpos.model.MenuItem) obj;
			if (null == this.getId() || null == menuItem.getId()) return this == obj;
			else return (this.getId().equals(menuItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}