package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the QUOTATION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="QUOTATION"
 */

public abstract class BaseQuotation  implements Comparable, Serializable {

	public static String REF = "Quotation"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_QUOTATION_ID = "quotationId"; //$NON-NLS-1$
	public static String PROP_INVOICE_ID = "invoiceId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_TICKET_JSON = "ticketJson"; //$NON-NLS-1$
	public static String PROP_ORDER_STATUS = "orderStatus"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_VOID_REASON = "voidReason"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CLOSING_DATE = "closingDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_DUE_DATE = "dueDate"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$


	// constructors
	public BaseQuotation () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseQuotation (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date createDate;
				private java.util.Date closingDate;
				private java.util.Date dueDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Boolean voided;
				private java.lang.String voidReason;
				private java.lang.Integer orderStatus;
				private java.lang.String customerId;
				private java.lang.String quotationId;
				private java.lang.String invoiceId;
				private java.lang.String outletId;
				private java.lang.String ticketJson;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.NumericGlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: INVOICING_DATE
	 */

	public java.util.Date getClosingDate () {
			return closingDate;
	}



	/**
	 * Set the value related to the column: INVOICING_DATE
	 * @param closingDate the INVOICING_DATE value
	 */
			public void setClosingDate (java.util.Date closingDate) {
			this.closingDate = closingDate;
	}



	/**
	 * Return the value associated with the column: DUE_DATE
	 */

	public java.util.Date getDueDate () {
			return dueDate;
	}



	/**
	 * Set the value related to the column: DUE_DATE
	 * @param dueDate the DUE_DATE value
	 */
			public void setDueDate (java.util.Date dueDate) {
			this.dueDate = dueDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: VOID_REASON
	 */

	public java.lang.String getVoidReason () {
			return voidReason;
	}



	/**
	 * Set the value related to the column: VOID_REASON
	 * @param voidReason the VOID_REASON value
	 */
			public void setVoidReason (java.lang.String voidReason) {
			this.voidReason = voidReason;
	}



	/**
	 * Return the value associated with the column: ORDER_STATUS
	 */

	public java.lang.Integer getOrderStatus () {
						return orderStatus == null ? Integer.valueOf(0) : orderStatus;
		}



	/**
	 * Set the value related to the column: ORDER_STATUS
	 * @param orderStatus the ORDER_STATUS value
	 */
			public void setOrderStatus (java.lang.Integer orderStatus) {
			this.orderStatus = orderStatus;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: QUOTATION_ID
	 */

	public java.lang.String getQuotationId () {
			return quotationId;
	}



	/**
	 * Set the value related to the column: QUOTATION_ID
	 * @param quotationId the QUOTATION_ID value
	 */
			public void setQuotationId (java.lang.String quotationId) {
			this.quotationId = quotationId;
	}



	/**
	 * Return the value associated with the column: INVOICE_ID
	 */

	public java.lang.String getInvoiceId () {
			return invoiceId;
	}



	/**
	 * Set the value related to the column: INVOICE_ID
	 * @param invoiceId the INVOICE_ID value
	 */
			public void setInvoiceId (java.lang.String invoiceId) {
			this.invoiceId = invoiceId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: TICKET_JSON
	 */

	public java.lang.String getTicketJson () {
			return ticketJson;
	}



	/**
	 * Set the value related to the column: TICKET_JSON
	 * @param ticketJson the TICKET_JSON value
	 */
			public void setTicketJson (java.lang.String ticketJson) {
			this.ticketJson = ticketJson;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Quotation)) return false;
		else {
			com.floreantpos.model.Quotation quotation = (com.floreantpos.model.Quotation) obj;
			if (null == this.getId() || null == quotation.getId()) return this == obj;
			else return (this.getId().equals(quotation.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}