package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.Bed;
import com.floreantpos.swing.PaginatedListModel;

public class BedDAO extends BaseBedDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public BedDAO() {
	}

	public void loadData(PaginatedListModel<Bed> tableModel, String name, List<String> roomIds) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(name)) {
				criteria.add(Restrictions.eq(Bed.PROP_NUMBER, name));
			}
			if (roomIds != null && roomIds.size() > 0) {
				criteria.add(Restrictions.in(Bed.PROP_ROOM_ID, roomIds));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.addOrder(Order.asc(Bed.PROP_ROOM_ID));
			criteria.addOrder(Order.asc(Bed.PROP_NUMBER));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			tableModel.setData(criteria.list());
		}
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public List<Bed> findAll(List<String> roomIds, String value) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			if (roomIds != null && roomIds.size() > 0) {
				criteria.add(Restrictions.in(Bed.PROP_ROOM_ID, roomIds));
			}
			criteria.add(Restrictions.or(Restrictions.eq(Bed.PROP_ACTIVE, Boolean.TRUE), Restrictions.isNull(Bed.PROP_ACTIVE)));
			criteria.addOrder(Order.asc(Bed.PROP_ROOM_ID));
			criteria.addOrder(Order.asc(Bed.PROP_NUMBER));
			return criteria.list();
		}
	}

	@Override
	protected void delete(Object obj, Session session) {
		Bed data = (Bed) obj;
		if (data == null) {
			throw new PosException("Data not found.");
		}
		data.setDeleted(Boolean.TRUE);
		saveOrUpdate(data, session);
	}

	public List<Bed> findByRoomId(String id) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(Bed.PROP_ROOM_ID, id));
			criteria.addOrder(Order.asc(Bed.PROP_NUMBER));
			return criteria.list();
		}
	}
}