package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;

import com.floreantpos.PosLog;
import com.floreantpos.model.Quotation;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.util.XMLTransientUtil;
import com.orocube.rest.service.ServiceUtils;

public class QuotationDAO extends BaseQuotationDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public QuotationDAO() {
	}

	@Override
	public Quotation get(String key, Session s) throws HibernateException {
		Quotation quotation = super.get(key, s);
		try {
			Ticket ticket = ServiceUtils.convertJsonToTicket(quotation.getTicketJson());
			if (ticket != null) {
				ticket.setOrderStatus(quotation.getOrderStatus());
			}
			quotation.setTicket(ticket);
		} catch (Exception e) {
			PosLog.error(getReferenceClass(), e);
		}
		return quotation;
	}

	public void saveOrUpdateQuotation(Quotation quotation, Ticket ticket, Session session) {
		if (StringUtils.isNotBlank(ticket.getId())) {
			quotation.setOrderStatus(Quotation.ORDER_CONFIMED);
			quotation.setInvoiceId(ticket.getId());
		}
		XMLTransientUtil.makeXMLTransient(ticket);
		try {
			quotation.setTicketJson(ServiceUtils.convertTicketToJson(ticket));
		} catch (Exception e) {
			PosLog.error(getReferenceClass(), e);
		}
		quotation.setDueDate(ticket.getDueDate());
		quotation.setCustomerId(ticket.getCustomerId());
		if (session == null) {
			saveOrUpdate(quotation);
		}
		else {
			saveOrUpdate(quotation, session);
		}

		List<TicketItem> ticketItems = ticket.getTicketItems();
		for (TicketItem ticketItem : ticketItems) {
			ticketItem.setTicket(ticket);
			if (ticketItem.isHasModifiers() && ticketItem.getTicketItemModifiers() != null) {
				for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
					ticketItemModifier.setTicketItem(ticketItem);
				}
			}
			List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
			if (discounts != null && discounts.size() > 0) {
				for (TicketItemDiscount ticketItemDiscount : discounts) {
					ticketItemDiscount.setTicketItem(ticketItem);
				}
			}
		}
		List<TicketDiscount> discounts = ticket.getDiscounts();
		if (discounts != null && discounts.size() > 0) {
			for (TicketDiscount ticketDiscount : discounts) {
				ticketDiscount.setTicket(ticket);
			}
		}
	}

}