package com.floreantpos.model.util.pricecalc;

import java.lang.reflect.Method;

public class PriceRuleFactory {
	private static PriceRuleService priceRuleService;

	public static PriceRuleService getPriceRuleService() {
		try {
			if (priceRuleService != null) {
				return priceRuleService;
			}
			Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.PriceRuleServiceImpl"); //$NON-NLS-1$
			Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
			priceRuleService = (PriceRuleService) method.invoke(null);
			return priceRuleService;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}