package com.floreantpos.services.report;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Customer;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;

public class CashDrawerDetailReport {
	public final static String TRANS_TIME = "transTime"; //$NON-NLS-1$
	public final static String PROP_TICKET = "ticket"; //$NON-NLS-1$
	public final static String INVOICE_ID = "invoiceId"; //$NON-NLS-1$
	public final static String RECEPIENT_ID = "recepientId"; //$NON-NLS-1$
	public final static String TRANSACTION_AMOUNT = "transactionAmount"; //$NON-NLS-1$
	public final static String PAYMENT_TYPE = "paymentType"; //$NON-NLS-1$

	private Date transTime;
	private String transTimeDisplay;
	private String properties;
	private Ticket ticket;
	private String invoiceId;
	private String recepientId;
	private Double transactionAmount;
	private String recepientName;
	private String customerName;
	private String invoiceDate;
	private String ticketId;
	private String paymentType;

	public CashDrawerDetailReport() {
	}

	public CashDrawerDetailReport(PosTransaction transaction, Date orderDate) {
		setTransactionAmount(transaction.getAmount());
		setTransTimeDisplay(DateUtil.formatReportDateWithBrowserTimeOffset(transaction.getTransactionTime()));
		setCustomerName(transaction.getRecepientName());
		setPaymentType(transaction.getPaymentTypeDisplayString());
		invoiceDate = DateUtil.formatReportDateWithBrowserTimeOffset(orderDate);

		String transTicketIds = transaction.getTransTicketIdsDisplay();
		if (!StringUtils.isNotBlank(transTicketIds) || !transTicketIds.contains(",")) {
			ticketId = transTicketIds;
		}

	}

	public String getTransTimeDisplay() {
		return transTimeDisplay;
	}

	public void setTransTimeDisplay(String transTimeDisplay) {
		this.transTimeDisplay = transTimeDisplay;
	}

	public String getProperties() {
		return properties;
	}

	public void setProperties(String properties) {
		this.properties = properties;
	}

	public void setInvoiceId(String invoiceId) {
		this.invoiceId = invoiceId;
	}

	public String getInvoiceId() {
		return invoiceId;
	}

	public Ticket getTicket() {
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

	public String getTicketId() {
		return ticketId;
	}

	public String getRecepientId() {
		return recepientId;
	}

	public void setRecepientName(String recepientIName) {
		this.recepientName = recepientIName;
	}

	public String getRecepientName() {
		return recepientName;
	}

	public void initCustomerName() {
		String recepientId = getRecepientId();
		if (StringUtils.isBlank(recepientId)) {
			setCustomerName(""); //$NON-NLS-1$
		}
		else {
			Customer customer = (Customer) DataProvider.get().getObjectOf(Customer.class, recepientId);
			if (customer == null) {
				setCustomerName(""); //$NON-NLS-1$
			}
			else {
				setCustomerName(customer.getName());
			}
		}
	}

	public void initInvoiceDate() {
		if (ticket != null) {
			invoiceDate = DateUtil.formatReportDateWithBrowserTimeOffset(ticket.getCreateDate());
		}
		if (transTime != null) {
			setTransTimeDisplay(DateUtil.formatReportDateWithBrowserTimeOffset(transTime));
		}

	}

	public void initRecepientName() {
		String recepientId = getRecepientId();
		if (StringUtils.isBlank(recepientId)) {
			setRecepientName(""); //$NON-NLS-1$
		}
		else {
			PayoutRecepient customer = (PayoutRecepient) DataProvider.get().getObjectOf(PayoutRecepient.class, recepientId);
			if (customer == null) {
				setRecepientName(""); //$NON-NLS-1$
			}
			else {
				setRecepientName(customer.getName());
			}
		}
		initInvoiceDate();
	}

	public void setRecepientId(String recepientId) {
		this.recepientId = recepientId;
	}

	public Double getTransactionAmount() {
		return transactionAmount;
	}

	public void setTransactionAmount(Double ticketAmount) {
		this.transactionAmount = ticketAmount;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public String getInvoiceDate() {
		return invoiceDate;
	}

	public Date getTransTime() {
		return transTime;
	}
	
	public String getPaymentType() {
		return paymentType;
		
	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}

}
