/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.util.DataProvider;

public enum BalanceType {
	//@formatter:off
	CUSTOMER("Customer"),  //$NON-NLS-1$
	GIFT_CARD("Gift Card"),  //$NON-NLS-1$
	LOYALTY("Loyalty"), //$NON-NLS-1$
	CASH_DRAWER_BALANCE("Cash drawer balance"), //$NON-NLS-1$
	ACCOUNTS_MANAGER_BALANCE("Accounts Manager balance"), //$NON-NLS-1$
	BANK_ACCOUNT_BALANCE("Bank account balance"), //$NON-NLS-1$
	STORE_BALANCE("Store balance"), //$NON-NLS-1$
	//AGENT_FEE_ADD("Agent fee add"), //$NON-NLS-1$
	//AGENT_FEE_PAYMENT("Agent fee payment"), //$NON-NLS-1$
	//DOCTOR_FEE_ADD("Doctor fee add"), //$NON-NLS-1$
	//DOCTOR_FEE_PAYMENT("Doctor fee payment"), //$NON-NLS-1$
	//LAB_DOCTOR_FEE_ADD("Lab docctor fee add"), //$NON-NLS-1$
	//LAB_DOCTOR_FEE_PAYMENT("Lab doctor fee payment"), //$NON-NLS-1$
	//OROSTORE_PAYMENT("Orostore Payment"),  //$NON-NLS-1$
	RESELLER_BALANCE("Reseller balance");  //$NON-NLS-1$
	//@formatter:on

	private String displayString;

	private BalanceType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayString(String displayString) {
		this.displayString = displayString;
	}

	public static BalanceType fromString(String s) {
		if (StringUtils.isEmpty(s)) {
			return null;
		}

		try {
			BalanceType filter = valueOf(s);
			return filter;
		} catch (Exception e) {
			return null;
		}
	}

	public static boolean match(String srcProductTypeName, BalanceType trgProductType) {
		BalanceType srcProductType = BalanceType.fromString(srcProductTypeName);
		return trgProductType.equals(srcProductType);
	}

	public BalanceUpdateTransaction createTransaction(PaymentType paymentType, TransactionType transactionType, double amount) {
		BalanceUpdateTransaction balanceTransaction = new BalanceUpdateTransaction();
		balanceTransaction.setPaymentType(paymentType);
		balanceTransaction.setTransactionType(transactionType.name());
		balanceTransaction.setBalanceType(this);
		Date now = DataProvider.get().getServerTimestamp();
		balanceTransaction.setEventTime(now);
		balanceTransaction.setTransactionTime(now);
		balanceTransaction
				.setAmount((transactionType == TransactionType.DEBIT || transactionType == TransactionType.OUT) ? -Math.abs(amount) : Math.abs(amount));
		balanceTransaction.setOutletId(DataProvider.get().getOutlet().getId());
		User currentUser = DataProvider.get().getCurrentUser();
		if (currentUser != null) {
			balanceTransaction.setPerformBy(currentUser.getId());
		}
		return balanceTransaction;
	}
}
