package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.floreantpos.model.dao.PayoutReasonDAO;
import com.floreantpos.model.dao.PayoutRecepientDAO;
import com.floreantpos.model.dao.PayoutSubReasonDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "paymentType", "balanceType" })
@XmlRootElement
public class BalanceUpdateTransaction extends BaseBalanceUpdateTransaction implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;

	public static final String JSON_PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static final String JSON_PROP_BALANCE_BEFORE = "balance.before"; //$NON-NLS-1$

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public BalanceUpdateTransaction() {
	}

	/**
	 * Constructor for primary key
	 */
	public BalanceUpdateTransaction(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public BalanceUpdateTransaction(java.lang.String id, java.lang.String balanceTypeString, java.lang.String paymentTypeString,
			java.lang.String transactionType, java.lang.String transactionSubType) {

		super(id, balanceTypeString, paymentTypeString, transactionType, transactionSubType);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setPaymentType(PaymentType paymentType) {
		setPaymentTypeString(paymentType != null ? paymentType.name() : null);
	}

	@XmlTransient
	public PaymentType getPaymentType() {
		String paymentTypeString = super.getPaymentTypeString();
		if (paymentTypeString == null) {
			return null;
		}
		return PaymentType.valueOf(paymentTypeString);
	}

	public void setBalanceType(BalanceType balanceType) {
		setBalanceTypeString(balanceType != null ? balanceType.name() : null);
	}

	@XmlTransient
	public BalanceType getBalanceType() {
		String balanceTypeString = super.getBalanceTypeString();
		if (balanceTypeString == null) {
			return null;
		}
		return BalanceType.fromString(balanceTypeString);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public String getExtraProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getExtraProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setExtraProperties(String properties) {
		super.setExtraProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public String getDescriptionDisplay() {
		String description = getDescription();

		String userId = getSalaryPaidTo();
		if (StringUtils.isNotBlank(userId)) {
			User user = DataProvider.get().getUserById(userId, getOutletId());
			if (user != null) {
				description += (StringUtils.isBlank(description) ? StringUtils.EMPTY : ", ") + "Employee: " + user.getFullName();
			}
		}

		String customePaymentInfoDisplay = getCustomePaymentInfoDisplay();
		if (StringUtils.isNotBlank(customePaymentInfoDisplay)) {
			description += (StringUtils.isBlank(description) ? StringUtils.EMPTY : ", ") + customePaymentInfoDisplay;
		}

		return description;
	}

	public String getDescription() {
		return getProperty(JSON_PROP_DESCRIPTION, "");
	}

	public void setDescription(String details) {
		addProperty(JSON_PROP_DESCRIPTION, details);
	}

	public Double getBalanceBefore() {
		return POSUtil.parseDouble(getProperty(JSON_PROP_BALANCE_BEFORE));
	}

	public void setBalanceBefore(double amount) {
		addProperty(JSON_PROP_BALANCE_BEFORE, String.valueOf(amount));
	}

	public String getCustomerName() {
		Customer customer = DataProvider.get().getCustomer(getAccountNumber());
		return customer == null ? "" : customer.getName();
	}

	public void putCustomerName() {

	}

	public String getCustomPaymnetId() {
		return getProperty("custom.paymnet.id", "");
	}

	public void setCustomPaymnetId(String customPaymnetId) {
		addProperty("custom.paymnet.id", customPaymnetId);
	}

	public String getCustomPaymnetRef() {
		return getProperty("custom.paymnet.ref", "");
	}

	public void setCustomPaymnetRef(String customPaymnetRef) {
		addProperty("custom.paymnet.ref", customPaymnetRef);
	}

	public String getPaymentTypeDisplayString() {
		PaymentType paymentType = getPaymentType();
		if (paymentType == PaymentType.CUSTOM_PAYMENT) {
			String customPaymnetId = getCustomPaymnetId();
			CustomPayment customPayment = DataProvider.get().getCustomPaymentById(customPaymnetId, getOutletId());
			if (customPayment != null) {
				return customPayment.getName();
			}
		}
		else if (paymentType == PaymentType.BANK_ACCOUNT) {
			return getBankAccountDisplay();
		}
		return paymentType.getDisplayString();
	}

	public String getBankAccountDisplay() {
		String bankAccountId = getBankAccountId();
		if (StringUtils.isNotBlank(bankAccountId)) {
			BankAccount bankAccount = (BankAccount) DataProvider.get().getObjectOf(BankAccount.class, bankAccountId);
			if (bankAccount != null) {
				return bankAccount.getDisplayString();
			}
		}
		return bankAccountId;

	}

	public String getEventTimeDisplay() {
		Date eventTime = getEventTime();
		return eventTime == null ? StringUtils.EMPTY : DateUtil.formatReportShortDateWithBrowserTimeOffset(eventTime);
	}

	public String getTransactionTimeDisplay() {
		if (this instanceof BalanceForwardTransaction) {
			return "Balance forward"; //$NON-NLS-1$
		}
		Date startTime = getTransactionTime();
		return startTime == null ? StringUtils.EMPTY : DateUtil.formatReportDateWithBrowserTimeOffset(startTime);
	}

	public String getAccountManager() {
		if (this instanceof BalanceForwardTransaction) {
			return "Balance forward";
		}

		if (this instanceof EndBalanceTransaction) {
			return "End Balance";
		}

		String userId = getAccountNumber();
		if (StringUtils.isNotBlank(userId)) {
			if (DataProvider.get().getStore().getId().equals(userId)) {
				return "Store";
			}

			User user = DataProvider.get().getUserById(userId, getOutletId());
			if (user != null) {
				return user.getFullName();
			}
		}
		return StringUtils.EMPTY;
	}

	public String getRecepientDisplay() {
		if (TransactionType.CREDIT.name().equals(getTransactionType())) {
			if (("ACCOUNTS_MANAGER_BALANCE").equals(getBalanceTypeString())) {
				return getAccountManager();
			}
		}
		if ((("TRANSFER_OUT").equals(getTransactionSubType()))) {
			return "Store"; //$NON-NLS-1$
		}

		String recepientId = getRecepientId();
		if (StringUtils.isNotEmpty(recepientId)) {
			PayoutRecepient recepient = PayoutRecepientDAO.getInstance().get(recepientId);
			return recepient != null ? recepient.getName() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getReasonDisplay() {
		if (this instanceof BalanceForwardTransaction) {
			return StringUtils.EMPTY;
		}
		else if (TransactionType.CREDIT.name().equals(this.getTransactionType())) {
			return "Cash in"; //$NON-NLS-1$
		}

		else if ((("TRANSFER_OUT").equals(this.getTransactionSubType()))) {
			return "Transfer out"; //$NON-NLS-1$
		}

		String reasonId = getReasonId();
		if (StringUtils.isNotEmpty(reasonId)) {
			PayoutReason payoutReason = PayoutReasonDAO.getInstance().get(reasonId);
			return payoutReason != null ? payoutReason.getReason() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getSubCategoryDisplay() {
		String subReasonId = getSubReasonId();
		if (StringUtils.isNotEmpty(subReasonId)) {
			PayoutSubReason subPayoutReason = PayoutSubReasonDAO.getInstance().get(subReasonId);
			return subPayoutReason != null ? subPayoutReason.getReason() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public String getProjectDisplay() {
		String projectId = getProjectId();
		if (StringUtils.isNotEmpty(projectId)) {
			Project project = ProjectDAO.getInstance().get(projectId);
			return project != null ? project.getName() : StringUtils.EMPTY;
		}
		return StringUtils.EMPTY;
	}

	public Double getExpenseAmountDisplay() {
		if (getAmount() == 0) {
			return 0d;
		}
		return Math.abs(getAmount());
	}

	public String getPerformBy() {
		return getProperty("perform.by", "");
	}

	public void setPerformBy(String performBy) {
		addProperty("perform.by", performBy);
	}

	public String getPerformByDisplay() {
		String performById = getPerformBy();
		if (StringUtils.isNotBlank(performById)) {
			User performBy = DataProvider.get().getUserById(performById, getOutletId());
			if (performBy != null) {
				return performBy.getFullName();
			}
		}
		return "";
	}

	public String getSalaryPaidTo() {
		return getProperty("user.salary_paid_to", "");
	}

	public void putSalaryPaidTo(String paidTo) {
		addProperty("user.salary_paid_to", paidTo);
	}

	/**
	 *  PosTransaction id
	 */
	public String getReferenceId() {
		return getProperty("reference_id", "");
	}

	/**
	 * @param referenceId
	 * 
	 * PosTransaction id
	 */
	public void putReferenceId(String referenceId) {
		addProperty("reference_id", referenceId);
	}

	/**
	 * @return
	 *  {@link BankAccount} id
	 */
	public String getBankAccountId() {
		return getProperty("bank_account_id", "");
	}

	/**
	 * @param bankOrCustomPaymentId
	 * 
	 * {@link BankAccount} id
	 */
	public void putBankAccountId(String bankOrCustomPaymentId) {
		addProperty("bank_account_id", bankOrCustomPaymentId);
	}

	public String getMemoNo() {
		return getProperty("memo_no", ""); //$NON-NLS-1$
	}

	public void putMemoNo(String memoNo) {
		addProperty("memo_no", memoNo); //$NON-NLS-1$
	}

	public String getMemoImageId() {
		return getProperty("memo_image_id"); //$NON-NLS-1$
	}

	public void putMemoImageId(String memoImageId) {
		addProperty("memo_image_id", memoImageId); //$NON-NLS-1$
	}

	public void putCustomePaymentInfo(String json) {
		addProperty("payment", json); //$NON-NLS-1$
	}

	public String getCustomePaymentInfo() {
		return getProperty("payment", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public String getCustomePaymentInfoDisplay() {
		String paymentRefStr = getCustomePaymentInfo().replace("\"", StringUtils.EMPTY).replace(",", ", ").replace(":", " : ");

		if (paymentRefStr.startsWith("[{") && paymentRefStr.endsWith("}]")) {
			return paymentRefStr.substring(2, paymentRefStr.length() - 2);
		}
		else if (paymentRefStr.startsWith("[") && paymentRefStr.endsWith("]")) {
			return paymentRefStr.substring(1, paymentRefStr.length() - 1);
		}

		return paymentRefStr;
	}

	public String getTransactionReason() {
		if (this instanceof BalanceForwardTransaction) {
			return StringUtils.EMPTY;
		}

		String transactionReason = getProperty("transactionReason"); //$NON-NLS-1$
		if (StringUtils.isNotBlank(transactionReason)) {
			return transactionReason;
		}

		if (getTransactionType().equals(TransactionType.CREDIT.name())) {
			return "Add balance"; //$NON-NLS-1$
		}

		String userId = getSalaryPaidTo();
		if (StringUtils.isNotEmpty(userId)) {
			User user = DataProvider.get().getUserById(userId, getOutletId());
			return user != null ? user.getFullName() : StringUtils.EMPTY;
		}

		return StringUtils.EMPTY;
	}

	public void putTransactionReason(String reason) {
		addProperty("transactionReason", reason);
	}

	public void putBalanceTransferInfo(User fromUser, User toUser, double balance) {
		addProperty("balance_transfer.from_user_id", fromUser.getId());
		addProperty("balance_transfer.to_user_id", toUser.getId());
		addProperty("balance_transfer.amount", NumberUtil.format(balance));
	}

	public String getOrderIdOrEmployeeId() {
		String orderId = getEntityNo();
		return StringUtils.isNotBlank(orderId) ? orderId : (StringUtils.isNotBlank(getTicketId()) ? getTicketId() : getSalaryPaidTo());
	}

	public String getEntityNo() {
		return getProperty("entityNo");
	}

	public void putEntityNo(String entityNo) {
		addProperty("entityNo", entityNo);
	}

	public String getEntityId() {
		return getProperty("entityId");
	}

	public void putEntityId(String entityId) {
		addProperty("entityId", entityId);
	}

	public String getEntityType() {
		return getProperty("entityType");
	}

	public void putEntityType(String entityType) {
		addProperty("entityType", entityType);
	}

	public String getTransactionDescription() {
		String description = getDescription();
		if (StringUtils.isBlank(description)) {
			String fromCashdrawerId = getFromCashdrawerId();
			String cashRegisterName = null;
			if (fromCashdrawerId != null) {
				cashRegisterName = "Deposit from register " + fromCashdrawerId; //$NON-NLS-1$
			}
			return description = cashRegisterName;
		}
		if (BalanceSubType.EXPENSE.name().equals(getTransactionSubType())) {
			description = "Expense"; //$NON-NLS-1$
		}
		if (TransactionType.CREDIT.name().equals(getTransactionType())) {
			description = "Cash in"; //$NON-NLS-1$
		}
		if (("TRANSFER_OUT").equals(getTransactionSubType())) {
			description = "Transfer to store"; //$NON-NLS-1$
		}
		return description;
	}

	public String getRequisitionId() {
		return getProperty("requisition.id");
	}

	public void putRequisitionId(String requisitionId) {
		addProperty("requisition.id", requisitionId);
	}
	
	public String getSourceId() {
		return getProperty("source_id", "");
	}

	public void putSourceId(String sourceId) {
		addProperty("source_id", sourceId);
	}

	public String getSourceType() {
		return getProperty("source_type", "");
	}

	public void putSourceType(String sourceType) {
		addProperty("source_type", sourceType);
	}
}