package com.floreantpos.model;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.base.BaseBed;
import com.floreantpos.model.dao.RoomDAO;

public class Bed extends BaseBed {
	private static final long serialVersionUID = 1L;
	private Room room;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Bed() {
	}

	/**
	 * Constructor for primary key
	 */
	public Bed(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return super.getNumber();
	}

	public Room getRoom() {
		if (room != null) {
			return room;
		}
		if (StringUtils.isNotBlank(super.getRoomId())) {
			room = RoomDAO.getInstance().get(super.getRoomId());
		}
		return room;
	}

	public void setRoom(Room room) {
		this.room = room;
	}

	public String getNameDisplay() {
		return getRoom().getName() + " bed " + getNumber().trim(); //$NON-NLS-1$
	}

}