package com.floreantpos.model;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseChallan;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.util.GsonUtil;
import com.floreantpos.util.NumberUtil;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class Challan extends BaseChallan implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;
	private transient boolean shouldUpdateStock;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Challan () {
    }

	/**
	 * Constructor for primary key
	 */
	public Challan (java.lang.String id) {
		super(id);
	}

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public List<ChallanItemDto> getItems() {
		Gson gson = GsonUtil.createGson();
		String itemData = getItemData();
		if (StringUtils.isBlank(itemData)) {
			Collections.emptyList();
		}
		return gson.fromJson(itemData, new TypeToken<List<ChallanItemDto>>() {
		}.getType());
	}

	public void putItems(List<ChallanItemDto> challanItems) {
		Gson gson = GsonUtil.createGson();
		setItemData(gson.toJson(challanItems));
	}

	public void addItem(ChallanItemDto challanItem) {
		List<ChallanItemDto> items = getItems();
		items.add(challanItem);
		putItems(items);
	}

	public String getCustomerId() {
		return getProperty("customer.id"); //$NON-NLS-1$
	}

	public void putCustomerId(String customerId) {
		addProperty("customer.id", customerId); //$NON-NLS-1$
	}

	public double getTotalAmount() {
		return NumberUtil.parseOrGetZero(getProperty("total.amount", "0")).doubleValue(); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putTotalAmount(double amount) {
		addProperty("total.amount", String.valueOf(amount)); //$NON-NLS-1$
	}

	public String getProjectNameDisplay() {
		String projectId = getProjectId();
		if (StringUtils.isBlank(projectId)) {
			return StringUtils.EMPTY;
		}
		Project project = ProjectDAO.getInstance().get(projectId);
		if (project == null) {
			return StringUtils.EMPTY;
		}
		return project.getNameDisplay();
	}

	public String getChallanNo() {
		return getProperty("challan.no"); //$NON-NLS-1$
	}

	public void putChallanNo(String challanNo) {
		addProperty("challan.no", challanNo); //$NON-NLS-1$
	}

	public String getProductType() {
		return getProperty("product.type"); //$NON-NLS-1$
	}

	public void putProductType(String productType) {
		addProperty("product.type", productType); //$NON-NLS-1$
	}

	public String getNote() {
		return getProperty("note"); //$NON-NLS-1$
	}

	public void putNote(String note) {
		addProperty("note", note); //$NON-NLS-1$
	}

	public boolean isShouldUpdateStock() {
		return shouldUpdateStock;
	}

	public void setShouldUpdateStock(boolean shouldUpdateStock) {
		this.shouldUpdateStock = shouldUpdateStock;
	}

	public String getCreatedUserId() {
		return getProperty("createdUserId"); //$NON-NLS-1$
	}

	public void putCreatedUserId(String createdUserId) {
		addProperty("createdUserId", createdUserId); //$NON-NLS-1$
	}
}