package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseSalaryTransaction;
import com.floreantpos.util.NumberUtil;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SalaryTransaction extends BaseSalaryTransaction {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public SalaryTransaction() {
	}

	/**
	 * Constructor for primary key
	 */
	public SalaryTransaction(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public SalaryTransaction(java.lang.String id, java.lang.String transactionType, java.lang.String paymentTypeString) {

		super(id, transactionType, paymentTypeString);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public double getAdvanceBackAmount() {
		return NumberUtil.parseOrGetZero(getExtraProperty("salary.advanceBackAmount")).doubleValue();
	}

	public void putAdvanceBackAmount(double amount) {
		addExtraProperty("salary.advanceBackAmount", NumberUtil.format(amount));
	}

	public void putDeductionGsonData(String deductionGsonData) {
		addProperty("salary.deduction_list_data", deductionGsonData);
	}

	public String getDeductionGsonData() {
		return getProperty("salary.deduction_list_data", "");
	}

	public void putTotalDeductionAmount(double amount) {
		addProperty("salary.total_deduction_amount", NumberUtil.format(amount));
	}

	public double getTotalDeductionAmount() {
		return NumberUtil.parseOrGetZero(getExtraProperty("salary.total_deduction_amount")).doubleValue();
	}

	public double getEmployeeMonthlySalaryAmount() {
		return NumberUtil.parseOrGetZero(getExtraProperty("monthly_salary_amount")).doubleValue();
	}

	public void putEmployeeMonthlySalaryAmount(double salaryAmount) {
		addProperty("monthly_salary_amount", NumberUtil.formatAmount(salaryAmount));
	}

}