/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.ext.DeviceType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.PaymentMethodJsonExtractor;
import com.floreantpos.model.util.TerminalUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "showServerName", "assignedUser", "outlet", "department", "salesArea",
		"terminalType"/*, "seatForeColor",
						"seatBgColor", "servingForeColor", "servingBgColor", "bookForeColor", "bookBgColor", "freeForeColor", "freeBgColor"*/ })
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "terminal")
public class Terminal extends BaseTerminal implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	public static final String JSON_PROP_PRINT_RECIEPT_ON_BUMP = "printReceiptOnBump"; //$NON-NLS-1$
	public static final String JSON_ENABLE_ITEM_DETAIL_SHOWING = "enableItemDetailShowing"; //$NON-NLS-1$
	public static final String JSON_PROP_CASH_DRAWER_TYPE_OPTION = "cash_drawer_type_option";//$NON-NLS-1$
	public static final int TYPE_MOBILE = 1;
	public static final String PROP_ID = "id"; //$NON-NLS-1$
	public static final String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private transient JsonObject propertiesContainer;

	private transient String deviceName;

	private transient User lastSelectedLabIncharge;
	private transient User lastSelectedLabTechnician;
	private transient Doctor lastSelectedLabDoctor;
	private transient String lastSelectedTestMethod;
	private transient DepositMethod lastSelectedDepositMethod;
	private transient User lastSelectedAccountManager;

	public Terminal() {
	}

	/**
	 * Constructor for primary key
	 */
	public Terminal(java.lang.Integer id, String outletId) {
		super(id, outletId);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Deprecated
	public com.floreantpos.model.User getAssignedUser() {
		return DataProvider.get().getUserById(getAssignedUserId(), getOutletId());
	}

	/**
	 * Set the value related to the column: ASSIGNED_USER
	 * @param assignedUser the ASSIGNED_USER value
	 */
	@Deprecated
	public void setAssignedUser(com.floreantpos.model.User assignedUser) {
		setAssignedUserId(assignedUser == null ? null : assignedUser.getId());
	}

	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
	@Transient
	public com.floreantpos.model.Outlet getOutlet() {
		String outletId = getOutletId();
		if (outletId == null) {
			return null;
		}
		//		Outlet outlet = DataProvider.get().getOutlet();
		//		if (outlet != null && outlet.getId().equals(outletId)) {
		//			return outlet;
		//		}

		return OutletDAO.getInstance().get(outletId);
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outlet the OUTLET_ID value
	 */
	public void setOutlet(com.floreantpos.model.Outlet outlet) {
		setOutletId(outlet == null ? null : outlet.getId());
	}

	/**
	 * Return the value associated with the column: DEPT_ID
	 */
	@Transient
	public com.floreantpos.model.Department getDepartment() {
		if (getDepartmentId() == null) {
			return null;
		}
		return DepartmentDAO.getInstance().get(getDepartmentId());
	}

	/**
	 * Set the value related to the column: DEPT_ID
	 * @param department the DEPT_ID value
	 */
	public void setDepartment(com.floreantpos.model.Department department) {
		setDepartmentId(department == null ? null : department.getId());
	}

	/**
	 * Return the value associated with the column: SALES_AREA_ID
	 */
	public com.floreantpos.model.SalesArea getSalesArea() {
		if (getSalesAreaId() == null) {
			return null;
		}
		return SalesAreaDAO.getInstance().get(getSalesAreaId());
	}

	/**
	 * Set the value related to the column: SALES_AREA_ID
	 * @param salesArea the SALES_AREA_ID value
	 */
	public void setSalesArea(com.floreantpos.model.SalesArea salesArea) {
		setSalesAreaId(salesArea == null ? null : salesArea.getId());
	}

	/**
	 * Return the value associated with the column: TERMINAL_TYPE_ID
	 */
	@Transient
	public com.floreantpos.model.TerminalType getTerminalType() {
		return DataProvider.get().getTerminalType(getTerminalTypeId(), getOutletId());
	}

	/**
	 * Set the value related to the column: TERMINAL_TYPE_ID
	 * @param terminalType the TERMINAL_TYPE_ID value
	 */
	public void setTerminalType(com.floreantpos.model.TerminalType terminalType) {
		setTerminalTypeId(terminalType == null ? null : terminalType.getId());
	}

	//	public boolean isCashDrawerAssigned() {
	//		return getActiveCurrentCashDrawer() != null;
	//	}

	@Override
	public String toString() {
		return getName() == null ? String.valueOf(getId()) : getName();
	}

	public boolean isShowTableNumber() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER) == null ? true
				: Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER));
	}

	public boolean isShowServerName() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE) == null ? true
				: Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE));
	}

	public boolean isShowTokenNum() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE) == null ? true
				: Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE));
	}

	public boolean isAutoPrintReceipt() {
		return false; //Boolean.valueOf(getProperty(PrintConfigurationView.AUTO_PRINT_RECEIPT, "false"));
	}

	public void setAutoPrintReceipt(boolean autoPrint) {
		//addProperty(PrintConfigurationView.AUTO_PRINT_RECEIPT, String.valueOf(autoPrint));
	}

	public void setPrimaryFontSize(int priFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE, String.valueOf(priFont));
	}

	public int getPrimaryFontSize() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE) == null ? 12
				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE));
	}

	public void setSecondaryFontSize(int secFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE, String.valueOf(secFont));
	}

	public int getSecondaryFontSize() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE) == null ? 2
				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE));
	}

	public void setBtnWidth(int btnWidth) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH, String.valueOf(btnWidth));
	}

	public int getBtnWidth() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH) == null ? 40 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH));
	}

	public void setBtnHeight(int btnHeight) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT, String.valueOf(btnHeight));
	}

	public int getBtnHeight() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT) == null ? 40 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT));
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public boolean isShowTableName() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NAME, "false")); //$NON-NLS-1$
	}

	@Override
	public String getExtraProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getExtraProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setExtraProperties(String properties) {
		super.setExtraProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public String getDeviceName() {
		return DeviceType.fromType(getDeviceType()).name().replaceAll("_", " "); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
	}

	public boolean isPrintRecieptOnBump() {
		return POSUtil.getBoolean(getProperty(JSON_PROP_PRINT_RECIEPT_ON_BUMP));
	}

	public void setPrintRecieptOnBump(boolean show) {
		addProperty(JSON_PROP_PRINT_RECIEPT_ON_BUMP, String.valueOf(show));
	}

	public boolean isEnableItemDetailShowing() {
		return POSUtil.getBoolean(getProperty(JSON_ENABLE_ITEM_DETAIL_SHOWING));
	}

	public void setEnableItemDetailShowing(boolean show) {
		addProperty(JSON_ENABLE_ITEM_DETAIL_SHOWING, String.valueOf(show));
	}

	public void setActivePaymentMethodId(String paymentMethodId) {
		addProperty(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_ID, paymentMethodId);
	}

	public String getActivePaymentMethodId() {
		return getProperty(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_ID);
	}

	public boolean isSwipeCardSupported() {
		return getBooleanProperty("support-swipe-card", true); //$NON-NLS-1$
	}

	public void setSwipeCardSupported(boolean b) {
		addProperty("support-swipe-card", String.valueOf(b)); //$NON-NLS-1$
	}

	public boolean isManualEntrySupported() {
		return getBooleanProperty("support-card-manual-entry", true); //$NON-NLS-1$
	}

	public void setManualEntrySupported(boolean b) {
		addProperty("support-card-manual-entry", String.valueOf(b)); //$NON-NLS-1$
	}

	public boolean isExtTerminalSupported() {
		return getBooleanProperty("support-ext-terminal", true); //$NON-NLS-1$
	}

	public void setExtTerminalSupported(boolean b) {
		addProperty("support-ext-terminal", String.valueOf(b)); //$NON-NLS-1$
	}

	public boolean isTwoCashDrawersEnable() {
		return getCashDrawerType().equals(CashDrawerType.DUAL_CASH_DRAWER.name());
	}

	public String getCashDrawerType() {
		String property = getProperty(JSON_PROP_CASH_DRAWER_TYPE_OPTION);
		if (StringUtils.isNotBlank(property)) {
			return property;
		}
		if (!isHasCashDrawer()) {
			return CashDrawerType.NO_CASH_DRAWER.name();
		}
		else {
			return CashDrawerType.SINGLE_CASH_DRAWER.name();
		}
	}

	@Override
	@Deprecated
	public void setCurrentCashDrawer(CashDrawer currentCashDrawer) {
		super.setCurrentCashDrawer(currentCashDrawer);
	}

	/**
	 * @deprecated Use {@link #getActiveCurrentCashDrawer()}
	 */
	@Override
	@Deprecated
	public CashDrawer getCurrentCashDrawer() {
		return super.getCurrentCashDrawer();
	}

	/**
	 * @deprecated Use {@link #getActiveCurrentCashDrawer()#getAssignedUser()}
	 */
	@Override
	@Deprecated
	public String getAssignedUserId() {
		return super.getAssignedUserId();
	}

	@Override
	@Deprecated
	public void setAssignedUserId(String assignedUserId) {
		super.setAssignedUserId(assignedUserId);
	}

	public CashDrawer getActiveCurrentCashDrawer() {
		//return CashDrawerDAO.getInstance().findCashDrawerByTerminalId(getId());
		return TerminalUtil.getActiveCurrentCashDrawer(getCashRegisterId());
	}

	public User getLastSelectedLabIncharge() {
		return lastSelectedLabIncharge;
	}

	public void setLastSelectedLabIncharge(User lastSelectedLabIncharge) {
		this.lastSelectedLabIncharge = lastSelectedLabIncharge;
	}

	public User getLastSelectedLabTechnician() {
		return lastSelectedLabTechnician;
	}

	public void setLastSelectedLabTechnician(User lastSelectedLabTechnician) {
		this.lastSelectedLabTechnician = lastSelectedLabTechnician;
	}

	public Doctor getLastSelectedLabDoctor() {
		return lastSelectedLabDoctor;
	}

	public void setLastSelectedLabDoctor(Doctor lastSelectedLabDoctor) {
		this.lastSelectedLabDoctor = lastSelectedLabDoctor;
	}

	public String getLastSelectedTestMethod() {
		return lastSelectedTestMethod;
	}

	public void setLastSelectedTestMethod(String lastSelectedTestMethod) {
		this.lastSelectedTestMethod = lastSelectedTestMethod;
	}

	public DepositMethod getLastSelectedDepositMethod() {
		return lastSelectedDepositMethod;
	}

	public void setLastSelectedDepositMethod(DepositMethod lastSelectedDepositMethod) {
		this.lastSelectedDepositMethod = lastSelectedDepositMethod;
	}

	public User getLastSelectedAccountManager() {
		return lastSelectedAccountManager;
	}

	public void setLastSelectedAccountManager(User lastSelectedAccountManager) {
		this.lastSelectedAccountManager = lastSelectedAccountManager;
	}

}