package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TICKET_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TICKET_ITEM"
 */

public abstract class BaseTicketItem  implements Comparable, Serializable {

	public static String REF = "TicketItem"; //$NON-NLS-1$
	public static String PROP_VAT_AMOUNT = "vatAmount"; //$NON-NLS-1$
	public static String PROP_SEAT = "seat"; //$NON-NLS-1$
	public static String PROP_PIZZA_SECTION_MODE_TYPE = "pizzaSectionModeType"; //$NON-NLS-1$
	public static String PROP_SHOULD_PRINT_TO_KITCHEN = "shouldPrintToKitchen"; //$NON-NLS-1$
	public static String PROP_REFERRER_FEE_ON_NET_SALES = "referrerFeeOnNetSales"; //$NON-NLS-1$
	public static String PROP_TAX_ON_SERVICE_CHARGE = "taxOnServiceCharge"; //$NON-NLS-1$
	public static String PROP_TOTAL_COST = "totalCost"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT_WITHOUT_MODIFIERS = "totalAmountWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_SERVICE_TYPE = "serviceType"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_SUBTOTAL = "adjustedSubtotal"; //$NON-NLS-1$
	public static String PROP_DISCOUNTS_PROPERTY = "discountsProperty"; //$NON-NLS-1$
	public static String PROP_REQUIRED_SHIPPING = "requiredShipping"; //$NON-NLS-1$
	public static String PROP_COURSE_NAME = "courseName"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_TAX = "adjustedTax"; //$NON-NLS-1$
	public static String PROP_PRINT_KITCHEN_STICKER = "printKitchenSticker"; //$NON-NLS-1$
	public static String PROP_QUANTITY_SHIPPED = "quantityShipped"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_UNIT_PRICE = "adjustedUnitPrice"; //$NON-NLS-1$
	public static String PROP_PRODUCT_TYPE = "productType"; //$NON-NLS-1$
	public static String PROP_UNIT_NAME = "unitName"; //$NON-NLS-1$
	public static String PROP_TEST_RESULT = "testResult"; //$NON-NLS-1$
	public static String PROP_REPORT_GROUP_ID = "reportGroupId"; //$NON-NLS-1$
	public static String PROP_SHIPPED = "shipped"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public static String PROP_LAB_DOCTOR_ID = "labDoctorId"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_NOTE = "note"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_APPLICABLE = "discountApplicable"; //$NON-NLS-1$
	public static String PROP_TREAT_AS_SEAT = "treatAsSeat"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAB_DOCTOR_FEE_PAID = "labDoctorFeePaid"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_TAX_WITHOUT_MODIFIERS = "adjustedTaxWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_REFUNDABLE = "serviceChargeRefundable"; //$NON-NLS-1$
	public static String PROP_SUBTOTAL_AMOUNT = "subtotalAmount"; //$NON-NLS-1$
	public static String PROP_PAYMENT_SYNC_PERCENTAGE = "paymentSyncPercentage"; //$NON-NLS-1$
	public static String PROP_TAX_INCLUDED = "taxIncluded"; //$NON-NLS-1$
	public static String PROP_ITEM_WASTED = "itemWasted"; //$NON-NLS-1$
	public static String PROP_INVENTORY_ADJUST_QTY = "inventoryAdjustQty"; //$NON-NLS-1$
	public static String PROP_COURSE_ID = "courseId"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_DISCOUNT = "adjustedDiscount"; //$NON-NLS-1$
	public static String PROP_VOID_REASON = "voidReason"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_TOTAL = "adjustedTotal"; //$NON-NLS-1$
	public static String PROP_VOIDED_ITEM_ID = "voidedItemId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_PRINTED_TO_KITCHEN = "printedToKitchen"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$
	public static String PROP_TICKET = "ticket"; //$NON-NLS-1$
	public static String PROP_LAB_DOCTOR_FEE = "labDoctorFee"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_APPLICABLE = "serviceChargeApplicable"; //$NON-NLS-1$
	public static String PROP_TICKET_DISCOUNT_APPLICABLE = "ticketDiscountApplicable"; //$NON-NLS-1$
	public static String PROP_GROUP_ID = "groupId"; //$NON-NLS-1$
	public static String PROP_TAX_EXEMPT = "taxExempt"; //$NON-NLS-1$
	public static String PROP_UNIT_PRICE = "unitPrice"; //$NON-NLS-1$
	public static String PROP_RETURNED_SOURCE = "returnedSource"; //$NON-NLS-1$
	public static String PROP_COMBO_CHILD = "comboChild"; //$NON-NLS-1$
	public static String PROP_GROUP_NAME = "groupName"; //$NON-NLS-1$
	public static String PROP_BRAND_ID = "brandId"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_SAMPLE_COLLECTION_DATE = "sampleCollectionDate"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_TAXES_PROPERTY = "taxesProperty"; //$NON-NLS-1$
	public static String PROP_UNIT_TYPE = "unitType"; //$NON-NLS-1$
	public static String PROP_REFERRER_FEE_ON_REPORT = "referrerFeeOnReport"; //$NON-NLS-1$
	public static String PROP_BEVERAGE = "beverage"; //$NON-NLS-1$
	public static String PROP_KITCHEN_STATUS = "kitchenStatus"; //$NON-NLS-1$
	public static String PROP_COOKING_INSTRUCTIONS_PROPERTY = "cookingInstructionsProperty"; //$NON-NLS-1$
	public static String PROP_PRINTER_GROUP_ID = "printerGroupId"; //$NON-NLS-1$
	public static String PROP_COMBO_ITEM = "comboItem"; //$NON-NLS-1$
	public static String PROP_FRACTIONAL_UNIT = "fractionalUnit"; //$NON-NLS-1$
	public static String PROP_SUBTOTAL_AMOUNT_WITHOUT_MODIFIERS = "subtotalAmountWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_DATA_VERSION = "dataVersion"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_RATE = "serviceChargeRate"; //$NON-NLS-1$
	public static String PROP_CATEGORY_ID = "categoryId"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_TOTAL_WITHOUT_MODIFIERS = "adjustedTotalWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_INVENTORY_ITEM = "inventoryItem"; //$NON-NLS-1$
	public static String PROP_VOID_DATE = "voidDate"; //$NON-NLS-1$
	public static String PROP_SHIPPED_DATE = "shippedDate"; //$NON-NLS-1$
	public static String PROP_PAID = "paid"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS = "adjustedSubtotalWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT_WITHOUT_MODIFIERS = "taxAmountWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE = "serviceCharge"; //$NON-NLS-1$
	public static String PROP_LAB_INCHARGE_ID = "labInchargeId"; //$NON-NLS-1$
	public static String PROP_ITEM_RETURNED = "itemReturned"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_TAX_EXEMPT_AMOUNT = "taxExemptAmount"; //$NON-NLS-1$
	public static String PROP_LAB_DOCTOR_FEE_PAID_AMOUNT = "labDoctorFeePaidAmount"; //$NON-NLS-1$
	public static String PROP_PIZZA_TYPE = "pizzaType"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_SERVICE = "service"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static String PROP_VAT_RATE = "vatRate"; //$NON-NLS-1$
	public static String PROP_UNIT_COST = "unitCost"; //$NON-NLS-1$
	public static String PROP_TOTAL_COST_WITHOUT_MODIFIERS = "totalCostWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_LAB_TEST_ID = "labTestId"; //$NON-NLS-1$
	public static String PROP_CATEGORY_NAME = "categoryName"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_WITHOUT_MODIFIERS = "discountWithoutModifiers"; //$NON-NLS-1$
	public static String PROP_SEAT_NUMBER = "seatNumber"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS = "adjustedDiscountWithoutModifiers"; //$NON-NLS-1$


	// constructors
	public BaseTicketItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTicketItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.lang.Integer dataVersion;
				private java.util.Date createDate;
				private java.util.Date voidDate;
				private java.lang.String menuItemId;
				private java.lang.Double quantity;
				private java.lang.Double quantityShipped;
				private java.lang.String name;
				private java.lang.String brandId;
				private java.lang.String unitName;
				private java.lang.String unitType;
				private java.lang.String productType;
				private java.lang.Boolean taxIncluded;
				private java.lang.String courseId;
				private java.lang.String courseName;
				private java.lang.String groupId;
				private java.lang.String groupName;
				private java.lang.String categoryId;
				private java.lang.String categoryName;
				private java.lang.Double unitPrice;
				private java.lang.Double unitCost;
				private java.lang.Double totalCost;
				private java.lang.Double totalCostWithoutModifiers;
				private java.lang.String labDoctorId;
				private java.lang.String labInchargeId;
				private java.lang.Double referrerFeeOnReport;
				private java.lang.Double referrerFeeOnNetSales;
				private java.lang.Double labDoctorFee;
				private java.lang.Boolean labDoctorFeePaid;
				private java.lang.Double labDoctorFeePaidAmount;
				private java.lang.String labTestId;
				private java.lang.String testResult;
				private java.lang.String note;
				private java.util.Date sampleCollectionDate;
				private java.lang.Double subtotalAmount;
				private java.lang.Double subtotalAmountWithoutModifiers;
				private java.lang.Double discountAmount;
				private java.lang.Double discountWithoutModifiers;
				private java.lang.Double taxAmount;
				private java.lang.Boolean taxExempt;
				private java.lang.Double taxExemptAmount;
				private java.lang.Double vatAmount;
				private java.lang.Double vatRate;
				private java.lang.Double taxAmountWithoutModifiers;
				private java.lang.Double totalAmount;
				private java.lang.Double totalAmountWithoutModifiers;
				private java.lang.Double adjustedUnitPrice;
				private java.lang.Double adjustedSubtotal;
				private java.lang.Double adjustedSubtotalWithoutModifiers;
				private java.lang.Double adjustedDiscount;
				private java.lang.Double adjustedDiscountWithoutModifiers;
				private java.lang.Double adjustedTax;
				private java.lang.Double adjustedTaxWithoutModifiers;
				private java.lang.Double adjustedTotal;
				private java.lang.Double adjustedTotalWithoutModifiers;
				private java.lang.Boolean paid;
				private java.lang.Boolean beverage;
				private java.lang.Boolean voided;
				private java.lang.String voidedItemId;
				private java.lang.Boolean inventoryItem;
				private java.lang.Double inventoryAdjustQty;
				private java.lang.Boolean shouldPrintToKitchen;
				private java.lang.Boolean printKitchenSticker;
				private java.lang.Boolean treatAsSeat;
				private java.lang.Integer seatNumber;
				private java.lang.Boolean fractionalUnit;
				private java.lang.Boolean printedToKitchen;
				private java.lang.String kitchenStatus;
				private java.lang.Boolean pizzaType;
				private java.lang.Integer pizzaSectionModeType;
				private java.lang.Boolean comboItem;
				private java.lang.Boolean comboChild;
				private java.lang.Boolean service;
				private java.lang.String serviceType;
				private java.lang.Double serviceChargeRate;
				private java.lang.Double serviceCharge;
				private java.lang.Boolean serviceChargeApplicable;
				private java.lang.Boolean taxOnServiceCharge;
				private java.lang.String printerGroupId;
				private java.lang.String reportGroupId;
				private java.lang.String taxesProperty;
				private java.lang.String discountsProperty;
				private java.lang.String cookingInstructionsProperty;
				private java.lang.String voidReason;
				private java.lang.Boolean itemWasted;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.Boolean requiredShipping;
				private java.lang.Boolean shipped;
				private java.util.Date shippedDate;
				private java.lang.Double paymentSyncPercentage;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.Boolean returnedSource;
				private java.lang.Boolean itemReturned;
				private java.lang.Boolean discountApplicable;
				private java.lang.Boolean ticketDiscountApplicable;
				private java.lang.Boolean serviceChargeRefundable;
	
	// many to one
	private com.floreantpos.model.Ticket ticket;
	private com.floreantpos.model.TicketItemSeat seat;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: DATA_VERSION
	 */

	public java.lang.Integer getDataVersion () {
						return dataVersion == null ? Integer.valueOf(0) : dataVersion;
		}



	/**
	 * Set the value related to the column: DATA_VERSION
	 * @param dataVersion the DATA_VERSION value
	 */
			public void setDataVersion (java.lang.Integer dataVersion) {
			this.dataVersion = dataVersion;
	}



	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: VOID_DATE
	 */

	public java.util.Date getVoidDate () {
			return voidDate;
	}



	/**
	 * Set the value related to the column: VOID_DATE
	 * @param voidDate the VOID_DATE value
	 */
			public void setVoidDate (java.util.Date voidDate) {
			this.voidDate = voidDate;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Double getQuantity () {
						return quantity == null ? Double.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Double quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: QUANTITY_SHIPPED
	 */

	public java.lang.Double getQuantityShipped () {
						return quantityShipped == null ? Double.valueOf(0) : quantityShipped;
		}



	/**
	 * Set the value related to the column: QUANTITY_SHIPPED
	 * @param quantityShipped the QUANTITY_SHIPPED value
	 */
			public void setQuantityShipped (java.lang.Double quantityShipped) {
			this.quantityShipped = quantityShipped;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: BRAND_ID
	 */

	public java.lang.String getBrandId () {
			return brandId;
	}



	/**
	 * Set the value related to the column: BRAND_ID
	 * @param brandId the BRAND_ID value
	 */
			public void setBrandId (java.lang.String brandId) {
			this.brandId = brandId;
	}



	/**
	 * Return the value associated with the column: UNIT_NAME
	 */

	public java.lang.String getUnitName () {
			return unitName;
	}



	/**
	 * set Unit id instead of unitName
	 * 
	 * Set the value related to the column: UNIT_NAME
	 * @param unitName the UNIT_NAME value
	 */
			public void setUnitName (java.lang.String unitName) {
			this.unitName = unitName;
	}



	/**
	 * Return the value associated with the column: UNIT_TYPE
	 */

	public java.lang.String getUnitType () {
			return unitType;
	}



	/**
	 * Set the value related to the column: UNIT_TYPE
	 * @param unitType the UNIT_TYPE value
	 */
			public void setUnitType (java.lang.String unitType) {
			this.unitType = unitType;
	}



	/**
	 * Return the value associated with the column: PRODUCT_TYPE
	 */

	public java.lang.String getProductType () {
			return productType;
	}



	/**
	 * Set the value related to the column: PRODUCT_TYPE
	 * @param productType the PRODUCT_TYPE value
	 */
			public void setProductType (java.lang.String productType) {
			this.productType = productType;
	}



	/**
	 * Return the value associated with the column: TAX_INCLUDED
	 */

	public java.lang.Boolean isTaxIncluded () {
					return taxIncluded == null ? Boolean.FALSE : taxIncluded;
		}

	public java.lang.Boolean getTaxIncluded () {
				return taxIncluded == null ? Boolean.FALSE : taxIncluded;
			}


	/**
	 * Set the value related to the column: TAX_INCLUDED
	 * @param taxIncluded the TAX_INCLUDED value
	 */
			public void setTaxIncluded (java.lang.Boolean taxIncluded) {
			this.taxIncluded = taxIncluded;
	}



	/**
	 * Return the value associated with the column: COURSE_ID
	 */

	public java.lang.String getCourseId () {
			return courseId;
	}



	/**
	 * Set the value related to the column: COURSE_ID
	 * @param courseId the COURSE_ID value
	 */
			public void setCourseId (java.lang.String courseId) {
			this.courseId = courseId;
	}



	/**
	 * Return the value associated with the column: COURSE_NAME
	 */

	public java.lang.String getCourseName () {
			return courseName;
	}



	/**
	 * Set the value related to the column: COURSE_NAME
	 * @param courseName the COURSE_NAME value
	 */
			public void setCourseName (java.lang.String courseName) {
			this.courseName = courseName;
	}



	/**
	 * Return the value associated with the column: GROUP_ID
	 */

	public java.lang.String getGroupId () {
			return groupId;
	}



	/**
	 * Set the value related to the column: GROUP_ID
	 * @param groupId the GROUP_ID value
	 */
			public void setGroupId (java.lang.String groupId) {
			this.groupId = groupId;
	}



	/**
	 * Return the value associated with the column: GROUP_NAME
	 */

	public java.lang.String getGroupName () {
			return groupName;
	}



	/**
	 * Set the value related to the column: GROUP_NAME
	 * @param groupName the GROUP_NAME value
	 */
			public void setGroupName (java.lang.String groupName) {
			this.groupName = groupName;
	}



	/**
	 * Return the value associated with the column: CATEGORY_ID
	 */

	public java.lang.String getCategoryId () {
			return categoryId;
	}



	/**
	 * Set the value related to the column: CATEGORY_ID
	 * @param categoryId the CATEGORY_ID value
	 */
			public void setCategoryId (java.lang.String categoryId) {
			this.categoryId = categoryId;
	}



	/**
	 * Return the value associated with the column: CATEGORY_NAME
	 */

	public java.lang.String getCategoryName () {
			return categoryName;
	}



	/**
	 * Set the value related to the column: CATEGORY_NAME
	 * @param categoryName the CATEGORY_NAME value
	 */
			public void setCategoryName (java.lang.String categoryName) {
			this.categoryName = categoryName;
	}



	/**
	 * Return the value associated with the column: UNIT_PRICE
	 */

	public java.lang.Double getUnitPrice () {
						return unitPrice == null ? Double.valueOf(0) : unitPrice;
		}



	/**
	 * Set the value related to the column: UNIT_PRICE
	 * @param unitPrice the UNIT_PRICE value
	 */
			public void setUnitPrice (java.lang.Double unitPrice) {
			this.unitPrice = unitPrice;
	}



	/**
	 * Return the value associated with the column: UNIT_COST
	 */

	public java.lang.Double getUnitCost () {
						return unitCost == null ? Double.valueOf(0) : unitCost;
		}



	/**
	 * Set the value related to the column: UNIT_COST
	 * @param unitCost the UNIT_COST value
	 */
			public void setUnitCost (java.lang.Double unitCost) {
			this.unitCost = unitCost;
	}



	/**
	 * Return the value associated with the column: TOTAL_COST
	 */

	public java.lang.Double getTotalCost () {
						return totalCost == null ? Double.valueOf(0) : totalCost;
		}



	/**
	 * Set the value related to the column: TOTAL_COST
	 * @param totalCost the TOTAL_COST value
	 */
			public void setTotalCost (java.lang.Double totalCost) {
			this.totalCost = totalCost;
	}



	/**
	 * Return the value associated with the column: TOTAL_COST_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getTotalCostWithoutModifiers () {
						return totalCostWithoutModifiers == null ? Double.valueOf(0) : totalCostWithoutModifiers;
		}



	/**
	 * Set the value related to the column: TOTAL_COST_WITHOUT_MODIFIERS
	 * @param totalCostWithoutModifiers the TOTAL_COST_WITHOUT_MODIFIERS value
	 */
			public void setTotalCostWithoutModifiers (java.lang.Double totalCostWithoutModifiers) {
			this.totalCostWithoutModifiers = totalCostWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: LAB_DOCTOR_ID
	 */

	public java.lang.String getLabDoctorId () {
			return labDoctorId;
	}



	/**
	 * Set the value related to the column: LAB_DOCTOR_ID
	 * @param labDoctorId the LAB_DOCTOR_ID value
	 */
			public void setLabDoctorId (java.lang.String labDoctorId) {
			this.labDoctorId = labDoctorId;
	}



	/**
	 * Return the value associated with the column: LAB_INCHARGE_ID
	 */

	public java.lang.String getLabInchargeId () {
			return labInchargeId;
	}



	/**
	 * Set the value related to the column: LAB_INCHARGE_ID
	 * @param labInchargeId the LAB_INCHARGE_ID value
	 */
			public void setLabInchargeId (java.lang.String labInchargeId) {
			this.labInchargeId = labInchargeId;
	}



	/**
	 * Return the value associated with the column: REFERRER_FEE_ON_REPORT
	 */

	public java.lang.Double getReferrerFeeOnReport () {
						return referrerFeeOnReport == null ? Double.valueOf(0) : referrerFeeOnReport;
		}



	/**
	 * Set the value related to the column: REFERRER_FEE_ON_REPORT
	 * @param referrerFeeOnReport the REFERRER_FEE_ON_REPORT value
	 */
			public void setReferrerFeeOnReport (java.lang.Double referrerFeeOnReport) {
			this.referrerFeeOnReport = referrerFeeOnReport;
	}



	/**
	 * Return the value associated with the column: REFERRER_FEE_ON_NET_SALES
	 */

	public java.lang.Double getReferrerFeeOnNetSales () {
						return referrerFeeOnNetSales == null ? Double.valueOf(0) : referrerFeeOnNetSales;
		}



	/**
	 * Set the value related to the column: REFERRER_FEE_ON_NET_SALES
	 * @param referrerFeeOnNetSales the REFERRER_FEE_ON_NET_SALES value
	 */
			public void setReferrerFeeOnNetSales (java.lang.Double referrerFeeOnNetSales) {
			this.referrerFeeOnNetSales = referrerFeeOnNetSales;
	}



	/**
	 * Return the value associated with the column: LAB_DOCTOR_FEE
	 */

	public java.lang.Double getLabDoctorFee () {
						return labDoctorFee == null ? Double.valueOf(0) : labDoctorFee;
		}



	/**
	 * Set the value related to the column: LAB_DOCTOR_FEE
	 * @param labDoctorFee the LAB_DOCTOR_FEE value
	 */
			public void setLabDoctorFee (java.lang.Double labDoctorFee) {
			this.labDoctorFee = labDoctorFee;
	}



	/**
	 * Return the value associated with the column: LAB_DOCTOR_FEE_PAID
	 */

	public java.lang.Boolean isLabDoctorFeePaid () {
						return labDoctorFeePaid == null ? Boolean.valueOf(false) : labDoctorFeePaid;
			}

	public java.lang.Boolean getLabDoctorFeePaid () {
					return labDoctorFeePaid == null ? Boolean.valueOf(false) : labDoctorFeePaid;
			}


	/**
	 * Set the value related to the column: LAB_DOCTOR_FEE_PAID
	 * @param labDoctorFeePaid the LAB_DOCTOR_FEE_PAID value
	 */
			public void setLabDoctorFeePaid (java.lang.Boolean labDoctorFeePaid) {
			this.labDoctorFeePaid = labDoctorFeePaid;
	}


	/**
	 * Custom property
	 */
	public static String getLabDoctorFeePaidDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: LAB_DOCTOR_FEE_PAID_AMOUNT
	 */

	public java.lang.Double getLabDoctorFeePaidAmount () {
						return labDoctorFeePaidAmount == null ? Double.valueOf(0) : labDoctorFeePaidAmount;
		}



	/**
	 * Set the value related to the column: LAB_DOCTOR_FEE_PAID_AMOUNT
	 * @param labDoctorFeePaidAmount the LAB_DOCTOR_FEE_PAID_AMOUNT value
	 */
			public void setLabDoctorFeePaidAmount (java.lang.Double labDoctorFeePaidAmount) {
			this.labDoctorFeePaidAmount = labDoctorFeePaidAmount;
	}



	/**
	 * Return the value associated with the column: LAB_TEST_ID
	 */

	public java.lang.String getLabTestId () {
			return labTestId;
	}



	/**
	 * Set the value related to the column: LAB_TEST_ID
	 * @param labTestId the LAB_TEST_ID value
	 */
			public void setLabTestId (java.lang.String labTestId) {
			this.labTestId = labTestId;
	}



	/**
	 * Return the value associated with the column: TEST_RESULT
	 */

	public java.lang.String getTestResult () {
			return testResult;
	}



	/**
	 * Set the value related to the column: TEST_RESULT
	 * @param testResult the TEST_RESULT value
	 */
			public void setTestResult (java.lang.String testResult) {
			this.testResult = testResult;
	}



	/**
	 * Return the value associated with the column: NOTE
	 */

	public java.lang.String getNote () {
			return note;
	}



	/**
	 * Set the value related to the column: NOTE
	 * @param note the NOTE value
	 */
			public void setNote (java.lang.String note) {
			this.note = note;
	}



	/**
	 * Return the value associated with the column: SAMPLE_COLLECTION_DATE
	 */

	public java.util.Date getSampleCollectionDate () {
			return sampleCollectionDate;
	}



	/**
	 * Set the value related to the column: SAMPLE_COLLECTION_DATE
	 * @param sampleCollectionDate the SAMPLE_COLLECTION_DATE value
	 */
			public void setSampleCollectionDate (java.util.Date sampleCollectionDate) {
			this.sampleCollectionDate = sampleCollectionDate;
	}



	/**
	 * Return the value associated with the column: SUB_TOTAL
	 */

	public java.lang.Double getSubtotalAmount () {
						return subtotalAmount == null ? Double.valueOf(0) : subtotalAmount;
		}



	/**
	 * Set the value related to the column: SUB_TOTAL
	 * @param subtotalAmount the SUB_TOTAL value
	 */
			public void setSubtotalAmount (java.lang.Double subtotalAmount) {
			this.subtotalAmount = subtotalAmount;
	}



	/**
	 * Return the value associated with the column: SUB_TOTAL_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getSubtotalAmountWithoutModifiers () {
						return subtotalAmountWithoutModifiers == null ? Double.valueOf(0) : subtotalAmountWithoutModifiers;
		}



	/**
	 * Set the value related to the column: SUB_TOTAL_WITHOUT_MODIFIERS
	 * @param subtotalAmountWithoutModifiers the SUB_TOTAL_WITHOUT_MODIFIERS value
	 */
			public void setSubtotalAmountWithoutModifiers (java.lang.Double subtotalAmountWithoutModifiers) {
			this.subtotalAmountWithoutModifiers = subtotalAmountWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: DISCOUNT
	 */

	public java.lang.Double getDiscountAmount () {
						return discountAmount == null ? Double.valueOf(0) : discountAmount;
		}



	/**
	 * Set the value related to the column: DISCOUNT
	 * @param discountAmount the DISCOUNT value
	 */
			public void setDiscountAmount (java.lang.Double discountAmount) {
			this.discountAmount = discountAmount;
	}



	/**
	 * Return the value associated with the column: DISCOUNT_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getDiscountWithoutModifiers () {
						return discountWithoutModifiers == null ? Double.valueOf(0) : discountWithoutModifiers;
		}



	/**
	 * Set the value related to the column: DISCOUNT_WITHOUT_MODIFIERS
	 * @param discountWithoutModifiers the DISCOUNT_WITHOUT_MODIFIERS value
	 */
			public void setDiscountWithoutModifiers (java.lang.Double discountWithoutModifiers) {
			this.discountWithoutModifiers = discountWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: TAX_AMOUNT
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TAX_AMOUNT
	 * @param taxAmount the TAX_AMOUNT value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: TAX_EXEMPT
	 */

	public java.lang.Boolean isTaxExempt () {
					return taxExempt == null ? Boolean.FALSE : taxExempt;
		}

	public java.lang.Boolean getTaxExempt () {
				return taxExempt == null ? Boolean.FALSE : taxExempt;
			}


	/**
	 * Set the value related to the column: TAX_EXEMPT
	 * @param taxExempt the TAX_EXEMPT value
	 */
			public void setTaxExempt (java.lang.Boolean taxExempt) {
			this.taxExempt = taxExempt;
	}



	/**
	 * Return the value associated with the column: TAX_EXEMPT_AMOUNT
	 */

	public java.lang.Double getTaxExemptAmount () {
						return taxExemptAmount == null ? Double.valueOf(0) : taxExemptAmount;
		}



	/**
	 * Set the value related to the column: TAX_EXEMPT_AMOUNT
	 * @param taxExemptAmount the TAX_EXEMPT_AMOUNT value
	 */
			public void setTaxExemptAmount (java.lang.Double taxExemptAmount) {
			this.taxExemptAmount = taxExemptAmount;
	}



	/**
	 * Return the value associated with the column: VAT_AMOUNT
	 */

	public java.lang.Double getVatAmount () {
						return vatAmount == null ? Double.valueOf(0) : vatAmount;
		}



	/**
	 * Set the value related to the column: VAT_AMOUNT
	 * @param vatAmount the VAT_AMOUNT value
	 */
			public void setVatAmount (java.lang.Double vatAmount) {
			this.vatAmount = vatAmount;
	}



	/**
	 * Return the value associated with the column: VAT_RATE
	 */

	public java.lang.Double getVatRate () {
						return vatRate == null ? Double.valueOf(0) : vatRate;
		}



	/**
	 * Set the value related to the column: VAT_RATE
	 * @param vatRate the VAT_RATE value
	 */
			public void setVatRate (java.lang.Double vatRate) {
			this.vatRate = vatRate;
	}



	/**
	 * Return the value associated with the column: TAX_AMOUNT_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getTaxAmountWithoutModifiers () {
						return taxAmountWithoutModifiers == null ? Double.valueOf(0) : taxAmountWithoutModifiers;
		}



	/**
	 * Set the value related to the column: TAX_AMOUNT_WITHOUT_MODIFIERS
	 * @param taxAmountWithoutModifiers the TAX_AMOUNT_WITHOUT_MODIFIERS value
	 */
			public void setTaxAmountWithoutModifiers (java.lang.Double taxAmountWithoutModifiers) {
			this.taxAmountWithoutModifiers = taxAmountWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalAmount () {
						return totalAmount == null ? Double.valueOf(0) : totalAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalAmount the TOTAL_PRICE value
	 */
			public void setTotalAmount (java.lang.Double totalAmount) {
			this.totalAmount = totalAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getTotalAmountWithoutModifiers () {
						return totalAmountWithoutModifiers == null ? Double.valueOf(0) : totalAmountWithoutModifiers;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE_WITHOUT_MODIFIERS
	 * @param totalAmountWithoutModifiers the TOTAL_PRICE_WITHOUT_MODIFIERS value
	 */
			public void setTotalAmountWithoutModifiers (java.lang.Double totalAmountWithoutModifiers) {
			this.totalAmountWithoutModifiers = totalAmountWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_UNIT_PRICE
	 */

	public java.lang.Double getAdjustedUnitPrice () {
						return adjustedUnitPrice == null ? Double.valueOf(0) : adjustedUnitPrice;
		}



	/**
	 * Set the value related to the column: ADJUSTED_UNIT_PRICE
	 * @param adjustedUnitPrice the ADJUSTED_UNIT_PRICE value
	 */
			public void setAdjustedUnitPrice (java.lang.Double adjustedUnitPrice) {
			this.adjustedUnitPrice = adjustedUnitPrice;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_SUBTOTAL
	 */

	public java.lang.Double getAdjustedSubtotal () {
						return adjustedSubtotal == null ? Double.valueOf(0) : adjustedSubtotal;
		}



	/**
	 * Set the value related to the column: ADJUSTED_SUBTOTAL
	 * @param adjustedSubtotal the ADJUSTED_SUBTOTAL value
	 */
			public void setAdjustedSubtotal (java.lang.Double adjustedSubtotal) {
			this.adjustedSubtotal = adjustedSubtotal;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getAdjustedSubtotalWithoutModifiers () {
						return adjustedSubtotalWithoutModifiers == null ? Double.valueOf(0) : adjustedSubtotalWithoutModifiers;
		}



	/**
	 * Set the value related to the column: ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS
	 * @param adjustedSubtotalWithoutModifiers the ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS value
	 */
			public void setAdjustedSubtotalWithoutModifiers (java.lang.Double adjustedSubtotalWithoutModifiers) {
			this.adjustedSubtotalWithoutModifiers = adjustedSubtotalWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_DISCOUNT
	 */

	public java.lang.Double getAdjustedDiscount () {
						return adjustedDiscount == null ? Double.valueOf(0) : adjustedDiscount;
		}



	/**
	 * Set the value related to the column: ADJUSTED_DISCOUNT
	 * @param adjustedDiscount the ADJUSTED_DISCOUNT value
	 */
			public void setAdjustedDiscount (java.lang.Double adjustedDiscount) {
			this.adjustedDiscount = adjustedDiscount;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getAdjustedDiscountWithoutModifiers () {
						return adjustedDiscountWithoutModifiers == null ? Double.valueOf(0) : adjustedDiscountWithoutModifiers;
		}



	/**
	 * Set the value related to the column: ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS
	 * @param adjustedDiscountWithoutModifiers the ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS value
	 */
			public void setAdjustedDiscountWithoutModifiers (java.lang.Double adjustedDiscountWithoutModifiers) {
			this.adjustedDiscountWithoutModifiers = adjustedDiscountWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_TAX
	 */

	public java.lang.Double getAdjustedTax () {
						return adjustedTax == null ? Double.valueOf(0) : adjustedTax;
		}



	/**
	 * Set the value related to the column: ADJUSTED_TAX
	 * @param adjustedTax the ADJUSTED_TAX value
	 */
			public void setAdjustedTax (java.lang.Double adjustedTax) {
			this.adjustedTax = adjustedTax;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_TAX_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getAdjustedTaxWithoutModifiers () {
						return adjustedTaxWithoutModifiers == null ? Double.valueOf(0) : adjustedTaxWithoutModifiers;
		}



	/**
	 * Set the value related to the column: ADJUSTED_TAX_WITHOUT_MODIFIERS
	 * @param adjustedTaxWithoutModifiers the ADJUSTED_TAX_WITHOUT_MODIFIERS value
	 */
			public void setAdjustedTaxWithoutModifiers (java.lang.Double adjustedTaxWithoutModifiers) {
			this.adjustedTaxWithoutModifiers = adjustedTaxWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_TOTAL
	 */

	public java.lang.Double getAdjustedTotal () {
						return adjustedTotal == null ? Double.valueOf(0) : adjustedTotal;
		}



	/**
	 * Set the value related to the column: ADJUSTED_TOTAL
	 * @param adjustedTotal the ADJUSTED_TOTAL value
	 */
			public void setAdjustedTotal (java.lang.Double adjustedTotal) {
			this.adjustedTotal = adjustedTotal;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_TOTAL_WITHOUT_MODIFIERS
	 */

	public java.lang.Double getAdjustedTotalWithoutModifiers () {
						return adjustedTotalWithoutModifiers == null ? Double.valueOf(0) : adjustedTotalWithoutModifiers;
		}



	/**
	 * Set the value related to the column: ADJUSTED_TOTAL_WITHOUT_MODIFIERS
	 * @param adjustedTotalWithoutModifiers the ADJUSTED_TOTAL_WITHOUT_MODIFIERS value
	 */
			public void setAdjustedTotalWithoutModifiers (java.lang.Double adjustedTotalWithoutModifiers) {
			this.adjustedTotalWithoutModifiers = adjustedTotalWithoutModifiers;
	}



	/**
	 * Return the value associated with the column: PAID
	 */

	public java.lang.Boolean isPaid () {
					return paid == null ? Boolean.FALSE : paid;
		}

	public java.lang.Boolean getPaid () {
				return paid == null ? Boolean.FALSE : paid;
			}


	/**
	 * Set the value related to the column: PAID
	 * @param paid the PAID value
	 */
			public void setPaid (java.lang.Boolean paid) {
			this.paid = paid;
	}



	/**
	 * Return the value associated with the column: BEVERAGE
	 */

	public java.lang.Boolean isBeverage () {
					return beverage == null ? Boolean.FALSE : beverage;
		}

	public java.lang.Boolean getBeverage () {
				return beverage == null ? Boolean.FALSE : beverage;
			}


	/**
	 * Set the value related to the column: BEVERAGE
	 * @param beverage the BEVERAGE value
	 */
			public void setBeverage (java.lang.Boolean beverage) {
			this.beverage = beverage;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: VOIDED_ITEM_ID
	 */

	public java.lang.String getVoidedItemId () {
			return voidedItemId;
	}



	/**
	 * Set the value related to the column: VOIDED_ITEM_ID
	 * @param voidedItemId the VOIDED_ITEM_ID value
	 */
			public void setVoidedItemId (java.lang.String voidedItemId) {
			this.voidedItemId = voidedItemId;
	}



	/**
	 * Return the value associated with the column: INVENTORY_ITEM
	 */

	public java.lang.Boolean isInventoryItem () {
						return inventoryItem == null ? Boolean.valueOf(true) : inventoryItem;
			}

	public java.lang.Boolean getInventoryItem () {
					return inventoryItem == null ? Boolean.valueOf(true) : inventoryItem;
			}


	/**
	 * Set the value related to the column: INVENTORY_ITEM
	 * @param inventoryItem the INVENTORY_ITEM value
	 */
			public void setInventoryItem (java.lang.Boolean inventoryItem) {
			this.inventoryItem = inventoryItem;
	}


	/**
	 * Custom property
	 */
	public static String getInventoryItemDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: INVENTORY_ADJUST_QTY
	 */

	public java.lang.Double getInventoryAdjustQty () {
						return inventoryAdjustQty == null ? Double.valueOf(0) : inventoryAdjustQty;
		}



	/**
	 * Set the value related to the column: INVENTORY_ADJUST_QTY
	 * @param inventoryAdjustQty the INVENTORY_ADJUST_QTY value
	 */
			public void setInventoryAdjustQty (java.lang.Double inventoryAdjustQty) {
			this.inventoryAdjustQty = inventoryAdjustQty;
	}



	/**
	 * Return the value associated with the column: PRINT_TO_KITCHEN
	 */

	public java.lang.Boolean isShouldPrintToKitchen () {
						return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}

	public java.lang.Boolean getShouldPrintToKitchen () {
					return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}


	/**
	 * Set the value related to the column: PRINT_TO_KITCHEN
	 * @param shouldPrintToKitchen the PRINT_TO_KITCHEN value
	 */
			public void setShouldPrintToKitchen (java.lang.Boolean shouldPrintToKitchen) {
			this.shouldPrintToKitchen = shouldPrintToKitchen;
	}


	/**
	 * Custom property
	 */
	public static String getShouldPrintToKitchenDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: PRINT_KITCHEN_STICKER
	 */

	public java.lang.Boolean isPrintKitchenSticker () {
						return printKitchenSticker == null ? Boolean.valueOf(false) : printKitchenSticker;
			}

	public java.lang.Boolean getPrintKitchenSticker () {
					return printKitchenSticker == null ? Boolean.valueOf(false) : printKitchenSticker;
			}


	/**
	 * Set the value related to the column: PRINT_KITCHEN_STICKER
	 * @param printKitchenSticker the PRINT_KITCHEN_STICKER value
	 */
			public void setPrintKitchenSticker (java.lang.Boolean printKitchenSticker) {
			this.printKitchenSticker = printKitchenSticker;
	}


	/**
	 * Custom property
	 */
	public static String getPrintKitchenStickerDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: TREAT_AS_SEAT
	 */

	public java.lang.Boolean isTreatAsSeat () {
					return treatAsSeat == null ? Boolean.FALSE : treatAsSeat;
		}

	public java.lang.Boolean getTreatAsSeat () {
				return treatAsSeat == null ? Boolean.FALSE : treatAsSeat;
			}


	/**
	 * Set the value related to the column: TREAT_AS_SEAT
	 * @param treatAsSeat the TREAT_AS_SEAT value
	 */
			public void setTreatAsSeat (java.lang.Boolean treatAsSeat) {
			this.treatAsSeat = treatAsSeat;
	}



	/**
	 * Return the value associated with the column: SEAT_NUMBER
	 */

	public java.lang.Integer getSeatNumber () {
						return seatNumber == null ? Integer.valueOf(0) : seatNumber;
		}



	/**
	 * Set the value related to the column: SEAT_NUMBER
	 * @param seatNumber the SEAT_NUMBER value
	 */
			public void setSeatNumber (java.lang.Integer seatNumber) {
			this.seatNumber = seatNumber;
	}



	/**
	 * Return the value associated with the column: FRACTIONAL_UNIT
	 */

	public java.lang.Boolean isFractionalUnit () {
					return fractionalUnit == null ? Boolean.FALSE : fractionalUnit;
		}

	public java.lang.Boolean getFractionalUnit () {
				return fractionalUnit == null ? Boolean.FALSE : fractionalUnit;
			}


	/**
	 * Set the value related to the column: FRACTIONAL_UNIT
	 * @param fractionalUnit the FRACTIONAL_UNIT value
	 */
			public void setFractionalUnit (java.lang.Boolean fractionalUnit) {
			this.fractionalUnit = fractionalUnit;
	}



	/**
	 * Return the value associated with the column: PRINTED_TO_KITCHEN
	 */

	public java.lang.Boolean isPrintedToKitchen () {
					return printedToKitchen == null ? Boolean.FALSE : printedToKitchen;
		}

	public java.lang.Boolean getPrintedToKitchen () {
				return printedToKitchen == null ? Boolean.FALSE : printedToKitchen;
			}


	/**
	 * Set the value related to the column: PRINTED_TO_KITCHEN
	 * @param printedToKitchen the PRINTED_TO_KITCHEN value
	 */
			public void setPrintedToKitchen (java.lang.Boolean printedToKitchen) {
			this.printedToKitchen = printedToKitchen;
	}



	/**
	 * Return the value associated with the column: KITCHEN_STATUS
	 */

	public java.lang.String getKitchenStatus () {
			return kitchenStatus;
	}



	/**
	 * Set the value related to the column: KITCHEN_STATUS
	 * @param kitchenStatus the KITCHEN_STATUS value
	 */
			public void setKitchenStatus (java.lang.String kitchenStatus) {
			this.kitchenStatus = kitchenStatus;
	}



	/**
	 * Return the value associated with the column: PIZZA_TYPE
	 */

	public java.lang.Boolean isPizzaType () {
					return pizzaType == null ? Boolean.FALSE : pizzaType;
		}

	public java.lang.Boolean getPizzaType () {
				return pizzaType == null ? Boolean.FALSE : pizzaType;
			}


	/**
	 * Set the value related to the column: PIZZA_TYPE
	 * @param pizzaType the PIZZA_TYPE value
	 */
			public void setPizzaType (java.lang.Boolean pizzaType) {
			this.pizzaType = pizzaType;
	}



	/**
	 * Return the value associated with the column: PIZZA_SECTION_MODE
	 */

	public java.lang.Integer getPizzaSectionModeType () {
						return pizzaSectionModeType == null ? Integer.valueOf(0) : pizzaSectionModeType;
		}



	/**
	 * Set the value related to the column: PIZZA_SECTION_MODE
	 * @param pizzaSectionModeType the PIZZA_SECTION_MODE value
	 */
			public void setPizzaSectionModeType (java.lang.Integer pizzaSectionModeType) {
			this.pizzaSectionModeType = pizzaSectionModeType;
	}



	/**
	 * Return the value associated with the column: ComboItem
	 */

	public java.lang.Boolean isComboItem () {
					return comboItem == null ? Boolean.FALSE : comboItem;
		}

	public java.lang.Boolean getComboItem () {
				return comboItem == null ? Boolean.FALSE : comboItem;
			}


	/**
	 * Set the value related to the column: ComboItem
	 * @param comboItem the ComboItem value
	 */
			public void setComboItem (java.lang.Boolean comboItem) {
			this.comboItem = comboItem;
	}



	/**
	 * Return the value associated with the column: COMBO_CHILD
	 */

	public java.lang.Boolean isComboChild () {
					return comboChild == null ? Boolean.FALSE : comboChild;
		}

	public java.lang.Boolean getComboChild () {
				return comboChild == null ? Boolean.FALSE : comboChild;
			}


	/**
	 * Set the value related to the column: COMBO_CHILD
	 * @param comboChild the COMBO_CHILD value
	 */
			public void setComboChild (java.lang.Boolean comboChild) {
			this.comboChild = comboChild;
	}



	/**
	 * Return the value associated with the column: IS_SERVICE
	 */

	public java.lang.Boolean isService () {
					return service == null ? Boolean.FALSE : service;
		}

	public java.lang.Boolean getService () {
				return service == null ? Boolean.FALSE : service;
			}


	/**
	 * Set the value related to the column: IS_SERVICE
	 * @param service the IS_SERVICE value
	 */
			public void setService (java.lang.Boolean service) {
			this.service = service;
	}



	/**
	 * Return the value associated with the column: SERVICE_TYPE
	 */

	public java.lang.String getServiceType () {
			return serviceType;
	}



	/**
	 * Set the value related to the column: SERVICE_TYPE
	 * @param serviceType the SERVICE_TYPE value
	 */
			public void setServiceType (java.lang.String serviceType) {
			this.serviceType = serviceType;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE_RATE
	 */

	public java.lang.Double getServiceChargeRate () {
						return serviceChargeRate == null ? Double.valueOf(0) : serviceChargeRate;
		}



	/**
	 * Set the value related to the column: SERVICE_CHARGE_RATE
	 * @param serviceChargeRate the SERVICE_CHARGE_RATE value
	 */
			public void setServiceChargeRate (java.lang.Double serviceChargeRate) {
			this.serviceChargeRate = serviceChargeRate;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE
	 */

	public java.lang.Double getServiceCharge () {
						return serviceCharge == null ? Double.valueOf(0) : serviceCharge;
		}



	/**
	 * Set the value related to the column: SERVICE_CHARGE
	 * @param serviceCharge the SERVICE_CHARGE value
	 */
			public void setServiceCharge (java.lang.Double serviceCharge) {
			this.serviceCharge = serviceCharge;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE_APPLICABLE
	 */

	public java.lang.Boolean isServiceChargeApplicable () {
					return serviceChargeApplicable == null ? Boolean.FALSE : serviceChargeApplicable;
		}

	public java.lang.Boolean getServiceChargeApplicable () {
				return serviceChargeApplicable == null ? Boolean.FALSE : serviceChargeApplicable;
			}


	/**
	 * Set the value related to the column: SERVICE_CHARGE_APPLICABLE
	 * @param serviceChargeApplicable the SERVICE_CHARGE_APPLICABLE value
	 */
			public void setServiceChargeApplicable (java.lang.Boolean serviceChargeApplicable) {
			this.serviceChargeApplicable = serviceChargeApplicable;
	}



	/**
	 * Return the value associated with the column: TAX_ON_SERVICE_CHARGE
	 */

	public java.lang.Boolean isTaxOnServiceCharge () {
					return taxOnServiceCharge == null ? Boolean.FALSE : taxOnServiceCharge;
		}

	public java.lang.Boolean getTaxOnServiceCharge () {
				return taxOnServiceCharge == null ? Boolean.FALSE : taxOnServiceCharge;
			}


	/**
	 * Set the value related to the column: TAX_ON_SERVICE_CHARGE
	 * @param taxOnServiceCharge the TAX_ON_SERVICE_CHARGE value
	 */
			public void setTaxOnServiceCharge (java.lang.Boolean taxOnServiceCharge) {
			this.taxOnServiceCharge = taxOnServiceCharge;
	}



	/**
	 * Return the value associated with the column: PG_ID
	 */

	public java.lang.String getPrinterGroupId () {
			return printerGroupId;
	}



	/**
	 * Set the value related to the column: PG_ID
	 * @param printerGroupId the PG_ID value
	 */
			public void setPrinterGroupId (java.lang.String printerGroupId) {
			this.printerGroupId = printerGroupId;
	}



	/**
	 * Return the value associated with the column: REPORT_GROUP_ID
	 */

	public java.lang.String getReportGroupId () {
			return reportGroupId;
	}



	/**
	 * Set the value related to the column: REPORT_GROUP_ID
	 * @param reportGroupId the REPORT_GROUP_ID value
	 */
			public void setReportGroupId (java.lang.String reportGroupId) {
			this.reportGroupId = reportGroupId;
	}



	/**
	 * Return the value associated with the column: TAXES_PROPERTY
	 */

	public java.lang.String getTaxesProperty () {
			return taxesProperty;
	}



	/**
	 * Set the value related to the column: TAXES_PROPERTY
	 * @param taxesProperty the TAXES_PROPERTY value
	 */
			public void setTaxesProperty (java.lang.String taxesProperty) {
			this.taxesProperty = taxesProperty;
	}



	/**
	 * Return the value associated with the column: DISCOUNTS_PROPERTY
	 */

	public java.lang.String getDiscountsProperty () {
			return discountsProperty;
	}



	/**
	 * Set the value related to the column: DISCOUNTS_PROPERTY
	 * @param discountsProperty the DISCOUNTS_PROPERTY value
	 */
			public void setDiscountsProperty (java.lang.String discountsProperty) {
			this.discountsProperty = discountsProperty;
	}



	/**
	 * Return the value associated with the column: COOKING_INSTRUCTIONS_PROPERTY
	 */

	public java.lang.String getCookingInstructionsProperty () {
			return cookingInstructionsProperty;
	}



	/**
	 * Set the value related to the column: COOKING_INSTRUCTIONS_PROPERTY
	 * @param cookingInstructionsProperty the COOKING_INSTRUCTIONS_PROPERTY value
	 */
			public void setCookingInstructionsProperty (java.lang.String cookingInstructionsProperty) {
			this.cookingInstructionsProperty = cookingInstructionsProperty;
	}



	/**
	 * Return the value associated with the column: VOID_REASON
	 */

	public java.lang.String getVoidReason () {
			return voidReason;
	}



	/**
	 * Set the value related to the column: VOID_REASON
	 * @param voidReason the VOID_REASON value
	 */
			public void setVoidReason (java.lang.String voidReason) {
			this.voidReason = voidReason;
	}



	/**
	 * Return the value associated with the column: ITEM_WASTED
	 */

	public java.lang.Boolean isItemWasted () {
					return itemWasted == null ? Boolean.FALSE : itemWasted;
		}

	public java.lang.Boolean getItemWasted () {
				return itemWasted == null ? Boolean.FALSE : itemWasted;
			}


	/**
	 * Set the value related to the column: ITEM_WASTED
	 * @param itemWasted the ITEM_WASTED value
	 */
			public void setItemWasted (java.lang.Boolean itemWasted) {
			this.itemWasted = itemWasted;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: REQUIRED_SHIPPING
	 */

	public java.lang.Boolean isRequiredShipping () {
					return requiredShipping == null ? Boolean.FALSE : requiredShipping;
		}

	public java.lang.Boolean getRequiredShipping () {
				return requiredShipping == null ? Boolean.FALSE : requiredShipping;
			}


	/**
	 * Set the value related to the column: REQUIRED_SHIPPING
	 * @param requiredShipping the REQUIRED_SHIPPING value
	 */
			public void setRequiredShipping (java.lang.Boolean requiredShipping) {
			this.requiredShipping = requiredShipping;
	}



	/**
	 * Return the value associated with the column: SHIPPED
	 */

	public java.lang.Boolean isShipped () {
					return shipped == null ? Boolean.FALSE : shipped;
		}

	public java.lang.Boolean getShipped () {
				return shipped == null ? Boolean.FALSE : shipped;
			}


	/**
	 * Set the value related to the column: SHIPPED
	 * @param shipped the SHIPPED value
	 */
			public void setShipped (java.lang.Boolean shipped) {
			this.shipped = shipped;
	}



	/**
	 * Return the value associated with the column: SHIPPED_DATE
	 */

	public java.util.Date getShippedDate () {
			return shippedDate;
	}



	/**
	 * Set the value related to the column: SHIPPED_DATE
	 * @param shippedDate the SHIPPED_DATE value
	 */
			public void setShippedDate (java.util.Date shippedDate) {
			this.shippedDate = shippedDate;
	}



	/**
	 * Return the value associated with the column: PAYMENT_SYNCED_PERCENTAGE
	 */

	public java.lang.Double getPaymentSyncPercentage () {
						return paymentSyncPercentage == null ? Double.valueOf(0) : paymentSyncPercentage;
		}



	/**
	 * Set the value related to the column: PAYMENT_SYNCED_PERCENTAGE
	 * @param paymentSyncPercentage the PAYMENT_SYNCED_PERCENTAGE value
	 */
			public void setPaymentSyncPercentage (java.lang.Double paymentSyncPercentage) {
			this.paymentSyncPercentage = paymentSyncPercentage;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: RETURNED_SOURCE
	 */

	public java.lang.Boolean isReturnedSource () {
						return returnedSource == null ? Boolean.valueOf(false) : returnedSource;
			}

	public java.lang.Boolean getReturnedSource () {
					return returnedSource == null ? Boolean.valueOf(false) : returnedSource;
			}


	/**
	 * Set the value related to the column: RETURNED_SOURCE
	 * @param returnedSource the RETURNED_SOURCE value
	 */
			public void setReturnedSource (java.lang.Boolean returnedSource) {
			this.returnedSource = returnedSource;
	}


	/**
	 * Custom property
	 */
	public static String getReturnedSourceDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: ITEM_RETURNED
	 */

	public java.lang.Boolean isItemReturned () {
						return itemReturned == null ? Boolean.valueOf(false) : itemReturned;
			}

	public java.lang.Boolean getItemReturned () {
					return itemReturned == null ? Boolean.valueOf(false) : itemReturned;
			}


	/**
	 * Set the value related to the column: ITEM_RETURNED
	 * @param itemReturned the ITEM_RETURNED value
	 */
			public void setItemReturned (java.lang.Boolean itemReturned) {
			this.itemReturned = itemReturned;
	}


	/**
	 * Custom property
	 */
	public static String getItemReturnedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: DISCOUNT_APPLICABLE
	 */

	public java.lang.Boolean isDiscountApplicable () {
						return discountApplicable == null ? Boolean.valueOf(true) : discountApplicable;
			}

	public java.lang.Boolean getDiscountApplicable () {
					return discountApplicable == null ? Boolean.valueOf(true) : discountApplicable;
			}


	/**
	 * Set the value related to the column: DISCOUNT_APPLICABLE
	 * @param discountApplicable the DISCOUNT_APPLICABLE value
	 */
			public void setDiscountApplicable (java.lang.Boolean discountApplicable) {
			this.discountApplicable = discountApplicable;
	}


	/**
	 * Custom property
	 */
	public static String getDiscountApplicableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: TICKET_DISCOUNT_APPLICABLE
	 */

	public java.lang.Boolean isTicketDiscountApplicable () {
						return ticketDiscountApplicable == null ? Boolean.valueOf(true) : ticketDiscountApplicable;
			}

	public java.lang.Boolean getTicketDiscountApplicable () {
					return ticketDiscountApplicable == null ? Boolean.valueOf(true) : ticketDiscountApplicable;
			}


	/**
	 * Set the value related to the column: TICKET_DISCOUNT_APPLICABLE
	 * @param ticketDiscountApplicable the TICKET_DISCOUNT_APPLICABLE value
	 */
			public void setTicketDiscountApplicable (java.lang.Boolean ticketDiscountApplicable) {
			this.ticketDiscountApplicable = ticketDiscountApplicable;
	}


	/**
	 * Custom property
	 */
	public static String getTicketDiscountApplicableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: SERVICE_CHARGE_REFUNDABLE
	 */

	public java.lang.Boolean isServiceChargeRefundable () {
						return serviceChargeRefundable == null ? Boolean.valueOf(true) : serviceChargeRefundable;
			}

	public java.lang.Boolean getServiceChargeRefundable () {
					return serviceChargeRefundable == null ? Boolean.valueOf(true) : serviceChargeRefundable;
			}


	/**
	 * Set the value related to the column: SERVICE_CHARGE_REFUNDABLE
	 * @param serviceChargeRefundable the SERVICE_CHARGE_REFUNDABLE value
	 */
			public void setServiceChargeRefundable (java.lang.Boolean serviceChargeRefundable) {
			this.serviceChargeRefundable = serviceChargeRefundable;
	}


	/**
	 * Custom property
	 */
	public static String getServiceChargeRefundableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public com.floreantpos.model.Ticket getTicket () {
			return ticket;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param ticket the OUTLET_ID value
	 */
			public void setTicket (com.floreantpos.model.Ticket ticket) {
			this.ticket = ticket;
	}



	/**
	 * Return the value associated with the column: SEAT_ID
	 */

	public com.floreantpos.model.TicketItemSeat getSeat () {
			return seat;
	}



	/**
	 * Set the value related to the column: SEAT_ID
	 * @param seat the SEAT_ID value
	 */
			public void setSeat (com.floreantpos.model.TicketItemSeat seat) {
			this.seat = seat;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.TicketItem)) return false;
		else {
			com.floreantpos.model.TicketItem ticketItem = (com.floreantpos.model.TicketItem) obj;
			if (null == this.getId() || null == ticketItem.getId()) return this == obj;
			else return (this.getId().equals(ticketItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}