package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Date;

import org.hibernate.Session;

import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.ExpenseTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PayoutSubReason;
import com.floreantpos.model.Project;
import com.floreantpos.model.Store;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;

public class ExpenseTransactionDAO extends BaseExpenseTransactionDAO {

	public ExpenseTransactionDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public ExpenseTransaction saveExpensesTransaction(User currentUser, Date eventTime, User accountsManager, String batchNo, Project project,
			PayoutRecepient recepient, PayoutReason reason, PayoutSubReason subReason, double expensesAmount, String note,
			BalanceUpdateTransaction balanceUpdateTransaction, Session session) throws Exception {

		ExpenseTransaction expenseTransaction = createTransaction(PaymentType.CASH, TransactionType.OUT, expensesAmount);
		expenseTransaction.setEventTime(eventTime);
		expenseTransaction.setBatchNo(batchNo);
		expenseTransaction.setRecepientId(recepient == null ? null : recepient.getId());
		expenseTransaction.setReasonId(reason == null ? null : reason.getId());
		expenseTransaction.setMemoNo(balanceUpdateTransaction.getMemoNo()); //$NON-NLS-1$
		expenseTransaction.addProperty("memo_image_id", balanceUpdateTransaction.getMemoImageId()); //$NON-NLS-1$
		expenseTransaction.setNote(note);
		expenseTransaction.setUser(currentUser);
		// set AccountNo to Server
		expenseTransaction.setServer(accountsManager);
		expenseTransaction.putAccountManagerId(accountsManager == null ? null : accountsManager.getId());
		expenseTransaction.setProjectId(project == null ? null : project.getId());
		expenseTransaction.setSubReasonId(subReason == null ? null : subReason.getId());

		expenseTransaction.setAccountProcessed(true);
		expenseTransaction.putSourceType(BalanceUpdateTransaction.REF);
		expenseTransaction.putSourceId(balanceUpdateTransaction.getId());

		save(expenseTransaction, session);
		return expenseTransaction;
	}

	public ExpenseTransaction saveStoreExpensesTransaction(User currentUser, Date eventTime, Store store, String batchNo, Project project,
			PayoutRecepient recepient, PayoutReason reason, PayoutSubReason subReason, double expensesAmount, String note,
			BalanceUpdateTransaction balanceUpdateTransaction, Session session) throws Exception {

		ExpenseTransaction expenseTransaction = createTransaction(PaymentType.CASH, TransactionType.OUT, expensesAmount);
		expenseTransaction.setEventTime(eventTime);
		expenseTransaction.setBatchNo(batchNo);
		expenseTransaction.setRecepientId(recepient == null ? null : recepient.getId());
		expenseTransaction.setReasonId(reason == null ? null : reason.getId());
		expenseTransaction.setNote(note);
		expenseTransaction.setUser(currentUser);
		// set AccountNo to Server
		expenseTransaction.setServerId(store.getId());
		expenseTransaction.putAccountManagerId(store == null ? null : store.getId());

		expenseTransaction.setProjectId(project == null ? null : project.getId());
		expenseTransaction.setSubReasonId(subReason == null ? null : subReason.getId());

		expenseTransaction.setAccountProcessed(true);
		expenseTransaction.putSourceType(BalanceUpdateTransaction.REF);
		expenseTransaction.putSourceId(balanceUpdateTransaction.getId());

		save(expenseTransaction, session);
		return expenseTransaction;

	}

	public ExpenseTransaction createTransaction(PaymentType paymentType, TransactionType transactionType, double amount) {
		ExpenseTransaction expenseTransaction = new ExpenseTransaction();
		expenseTransaction.setPaymentType(paymentType);
		expenseTransaction.setTransactionType(transactionType.name());
		Date now = DataProvider.get().getServerTimestamp();
		expenseTransaction.setTransactionTime(now);
		expenseTransaction.setAmount(transactionType == TransactionType.DEBIT ? -Math.abs(amount) : Math.abs(amount));
		expenseTransaction.setOutletId(DataProvider.get().getOutlet().getId());
		return expenseTransaction;
	}

}