package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.model.Appointment;
import com.floreantpos.model.AppointmentStatus;
import com.floreantpos.model.Prescription;

public class PrescriptionDAO extends BasePrescriptionDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public PrescriptionDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session s) {
		if (obj instanceof Prescription) {
			Prescription purchaseOrder = (Prescription) obj;
			purchaseOrder.setDeleted(Boolean.TRUE);
			super.update(purchaseOrder, s);
		}
		else {
			super.delete(obj, s);
		}
	}

	public void savePrescriptionAndAppointment(Prescription prescription, String appoinmentId) {
		try (Session session = createNewSession()) {
			Transaction transaction = session.beginTransaction();

			save(prescription, session);

			if (StringUtils.isNotBlank(appoinmentId)) {
				Appointment appointment = session.get(Appointment.class, appoinmentId);
				if (appointment != null
						&& Arrays.asList(AppointmentStatus.BOOKED.name(), AppointmentStatus.ON_GOING.name()).contains(appointment.getStatus())) {
					appointment.setStatus(AppointmentStatus.COMPLETED.name());
					session.saveOrUpdate(appointment);
				}
			}

			transaction.commit();
		}
	}
}