package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.SalaryAdvanceTransaction;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.NumberUtil;

public class SalaryAdvanceTransactionDAO extends BaseSalaryAdvanceTransactionDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public SalaryAdvanceTransaction saveSalaryAdvanceTransaction(Date eventTime, String batchNo, String projectId, Object paymentMethod, String paymentRef,
			User accountsManager, User paidToUser, double advanceAmount, String note, Session session)
			throws Exception {
		
		if (Math.abs(advanceAmount) == 0) {
			return null;
		}

		Double beforeSalaryAdvancedAmount = paidToUser.getSalaryAdvanced();

		SalaryAdvanceTransaction salaryAdvanceTransaction = createTransaction(paymentMethod, paymentRef, TransactionType.OUT, advanceAmount);
		salaryAdvanceTransaction.setEventTime(eventTime);
		salaryAdvanceTransaction.setBatchNo(batchNo);
		salaryAdvanceTransaction.setProjectId(projectId);
		// set AccountNo to Server
		salaryAdvanceTransaction.setServer(accountsManager);
		salaryAdvanceTransaction.putAccountManagerId(accountsManager == null ? null : accountsManager.getId());
		//paid salary to
		salaryAdvanceTransaction.setUser(paidToUser);
		salaryAdvanceTransaction.putSalaryPaidTo(paidToUser == null ? null : paidToUser.getId());

		salaryAdvanceTransaction.setNote(note);
		salaryAdvanceTransaction.setAccountProcessed(true);

		save(salaryAdvanceTransaction, session);

		double salaryAdvancedAmount = NumberUtil.round(beforeSalaryAdvancedAmount + advanceAmount);
		paidToUser.setSalaryAdvanced(salaryAdvancedAmount);
		UserDAO.getInstance().saveOrUpdate(paidToUser, session);

		return salaryAdvanceTransaction;
	}

	public SalaryAdvanceTransaction createTransaction(Object paymentMethod, String paymentRef, TransactionType transactionType, double amount) {
		SalaryAdvanceTransaction salaryAdvanceTransaction = new SalaryAdvanceTransaction();

		PaymentType paymentType = SalaryTransactionDAO.initPaymentMethod(paymentMethod, paymentRef, salaryAdvanceTransaction);

		salaryAdvanceTransaction.setPaymentType(paymentType);
		salaryAdvanceTransaction.setTransactionType(transactionType.name());
		salaryAdvanceTransaction.setTransactionTime(DataProvider.get().getServerTimestamp());
		salaryAdvanceTransaction.setAmount(transactionType == TransactionType.DEBIT ? -Math.abs(amount) : Math.abs(amount));
		salaryAdvanceTransaction.setOutletId(DataProvider.get().getOutlet().getId());
		return salaryAdvanceTransaction;
	}

	public void loadSalaryAdvancePayment(PaginationSupport model, String salaryUserId, String projectId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(SalaryAdvanceTransaction.class);

			criteria.add(Restrictions.eq(SalaryAdvanceTransaction.PROP_VOIDED, false));
			//criteria.add(Restrictions.between(SalaryAdvanceTransaction.PROP_EVENT_TIME, startOfMonth, endOfMonth));
			if (StringUtils.isNotBlank(salaryUserId)) {
				criteria.add(Restrictions.eq(SalaryAdvanceTransaction.PROP_USER_ID, salaryUserId));
			}

			if (StringUtils.isNotBlank(projectId)) {
				criteria.add(Restrictions.eq(SalaryAdvanceTransaction.PROP_PROJECT_ID, projectId));
			}

			criteria.setProjection(Projections.rowCount());
			Number rowCount = (Number) criteria.uniqueResult();
			model.setNumRows(rowCount.intValue());

			criteria.setProjection(null);
			criteria.setFirstResult(model.getCurrentRowIndex());
			criteria.setMaxResults(model.getPageSize());

			List<SalaryAdvanceTransaction> transactions = criteria.list();
			transactions.sort(Comparator.comparing(SalaryAdvanceTransaction::getUserName, Comparator.nullsLast(Comparator.naturalOrder())));
			model.setRows(transactions);
		}
	}

}