package com.floreantpos.model.dao;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.Tag;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class TagDAO extends BaseTagDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public TagDAO() {
	}

	public boolean isExists(String tagName) {
		Session session = null;

		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Tag.PROP_NAME, tagName));
			List list = criteria.list();

			return list != null && list.size() > 0;
		} finally {
			closeSession(session);
		}

	}

	public List<Tag> getAllContainer() {
		return getTagBy(Tag.CONTAINER_TYPE);
	}

	public List<Tag> getAllDeduction() {
		return getTagBy(Tag.DEDUCTION_TYPE);
	}

	public List<Tag> getTagBy(String tagType) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Tag.class);
			criteria.add(Restrictions.eq(Tag.PROP_TYPE, tagType));
			criteria.addOrder(Order.asc(Tag.PROP_NAME));
			return criteria.list();
		}
	}

	public Tag findContainerByName(String containerName) {
		try (Session session = createNewSession()) {
			return findContainerByName(containerName, session);
		}
	}

	public Tag findContainerByName(String containerName, Session session) {
		Criteria criteria = session.createCriteria(Tag.class);
		criteria.add(Restrictions.eq(Tag.PROP_NAME, containerName).ignoreCase());
		criteria.add(Restrictions.eq(Tag.PROP_TYPE, Tag.CONTAINER_TYPE));
		criteria.setMaxResults(1);
		return (Tag) criteria.uniqueResult();
	}

	public void saveOrUpdateTagList(List<Tag> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		saveOrUpdateTagList(dataList, updateLastUpdateTime, updateSyncTime, false, false);
	}

	public void saveOrUpdateTagList(List<Tag> dataList, boolean updateLastUpdateTime, boolean updateSyncTime, boolean saveNewDataOnly, boolean forceUpdate)
			throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<Tag> iterator = dataList.iterator(); iterator.hasNext();) {
				Tag item = (Tag) iterator.next();
				Tag existingItem = get(item.getId());
				if (existingItem != null) {
					if (!forceUpdate && (saveNewDataOnly || !BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime()))) {
						PosLog.info(getClass(), item.getName() + " already updated"); //$NON-NLS-1$
						continue;
					}
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					Tag container = findContainerByName(item.getName(), session);
					if (container != null) {
						continue;
					}
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}
	}
}