package com.floreantpos.report.model;

import com.floreantpos.report.ReferralCommissionReportData;
import com.floreantpos.swing.ListTableModel;

public class ReferralDetailsReportModel extends ListTableModel {
	public ReferralDetailsReportModel() {
		super(new String[] { "referralType", "referralBy", "orderId", "orderDate", "receivable", "due", "received", "reportDoctor", "agentFee", "labDoctorFee",
				"RFOnReport", "ofcNet", "RFOnNetSales", "RFpayable", "RFpaid", "rfDue", "ofcTotal", "totalRfAmount", "dueCollection" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		ReferralCommissionReportData reportData = (ReferralCommissionReportData) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return reportData.getReferralType();

			case 1:
				return reportData.getReferralBy() + " (" + reportData.getReferralId() + ")";

			case 2:
				return reportData.getOrderId();

			case 3:
				return reportData.getOrderDate();

			case 4:
				return reportData.getReceivable();

			case 5:
				return reportData.getDue();

			case 6:
				return reportData.getReceived();

			case 7:
				return reportData.getReportDoctor();

			case 8:
				return reportData.getAgentCommissionTotal();

			case 9:
				return reportData.getLabDoctorFee();

			case 10:
				return reportData.getRfOnReport();

			case 11:
				return reportData.getOfficeNet();

			case 12:
				return reportData.getRfOnNetSales();

			case 13:
				return reportData.getRfPayableAmount();

			case 14:
				return reportData.getRfPaid();

			case 15:
				return reportData.getRfFeeDue();

			case 16:
				return reportData.getOfficeTotal();

			case 17:
				return reportData.getTotalRF();

			case 18:
				return reportData.getDueColl();

		}
		return null;
	}

}