package com.floreantpos.model.util;

import java.util.List;

import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ext.UnitBaseItemPrice;
import com.floreantpos.model.util.pricecalc.DataUtilCalcFactory;

public class InventoryUnitConvertionUtil {

	public static double calculateCost(Double unitCost, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem) {
		return DataUtilCalcFactory.getCalc().calculateCost(unitCost, sourceUnit, targetUnit, menuItem);
	}

	public static double calculatePrice(Double unitPrice, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem) {
		return DataUtilCalcFactory.getCalc().calculatePrice(unitPrice, sourceUnit, targetUnit, menuItem);
	}

	public static double getUnitQuantity(IUnit sourceInventoryUnit, IUnit destinationInventoryUnit, MenuItem menuItem) {
		return DataUtilCalcFactory.getCalc().getUnitQuantity(sourceInventoryUnit, destinationInventoryUnit, menuItem);
	}

	public static double getBaseUnitQuantity(String unitId, MenuItem menuItem) {
		return DataUtilCalcFactory.getCalc().getBaseUnitQuantity(unitId, menuItem);
	}

	public static List<UnitBaseItemPrice> buildUnitBasePriceList(MenuItem menuItem, boolean regeneratePrice) {
		return DataUtilCalcFactory.getCalc().buildUnitBasePriceList(menuItem, regeneratePrice);
	}
	
	public static double calculateTestItemPrice(Double unitPrice, IUnit sourceUnit, IUnit targetUnit) {
		return DataUtilCalcFactory.getCalc().calculateTestItemPrice(unitPrice, sourceUnit, targetUnit);
	}

}
