package com.floreantpos.model.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.PosLog;
import com.floreantpos.model.DoctorTimeSchedule;
import com.floreantpos.model.OutdoorDoctorProfile;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;

public class OutdoorDoctorScheduleUtil {
	public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm a"); //$NON-NLS-1$

	public static DoctorTimeSchedule getCurrentDoctorSchedule(OutdoorDoctorProfile doctorProfile, String shiftId) {
		if (StringUtils.isNotBlank(shiftId)) {
			return doctorProfile.getSchedule(shiftId);
		}
		Date currentTime = DateUtil.convertServerTimeToBrowserTime(StoreDAO.getServerTimestamp());
		List<DoctorTimeSchedule> avaiableSchedules = new ArrayList<>();
		Set<Integer> availableDays = new HashSet<Integer>();
		if (doctorProfile != null) {
			List<DoctorTimeSchedule> doctorSchedules = doctorProfile.getSchedules();
			if (doctorSchedules != null && !doctorSchedules.isEmpty()) {
				if (currentTime != null) {
					for (DoctorTimeSchedule doctorTimeSchedule : doctorSchedules) {
						if (hasSchedule(doctorTimeSchedule, currentTime)) {
							avaiableSchedules.add(doctorTimeSchedule);
						}
						availableDays.addAll(doctorTimeSchedule.getDays());
					}
				}
			}
		}
		if (doctorProfile != null && avaiableSchedules.isEmpty() && currentTime != null) {
			return null;
		}
		if (avaiableSchedules.size() > 0) {
			Calendar c = Calendar.getInstance();
			c.setTime(currentTime);
			for (DoctorTimeSchedule schedule : avaiableSchedules) {
				try {
					Calendar start = Calendar.getInstance();
					try {
						start.setTime(simpleDateFormat.parse(schedule.getStartTime()));
					} catch (ParseException e) {
					}
					start.set(Calendar.SECOND, 0);
					start.set(Calendar.MILLISECOND, 0);
					start.set(Calendar.DAY_OF_MONTH, c.get(Calendar.DAY_OF_MONTH));
					start.set(Calendar.MONTH, c.get(Calendar.MONTH));
					start.set(Calendar.YEAR, c.get(Calendar.YEAR));

					Calendar end = Calendar.getInstance();
					try {
						end.setTime(simpleDateFormat.parse(schedule.getEndTime()));
					} catch (ParseException e) {
					}
					end.set(Calendar.SECOND, 0);
					end.set(Calendar.MILLISECOND, 0);
					end.set(Calendar.DAY_OF_MONTH, c.get(Calendar.DAY_OF_MONTH));
					end.set(Calendar.MONTH, c.get(Calendar.MONTH));
					end.set(Calendar.YEAR, c.get(Calendar.YEAR));

					boolean dayChanged = false;
					int amPM = start.get(Calendar.AM_PM);
					if (amPM == Calendar.PM) {
						int cAmPM = end.get(Calendar.AM_PM);
						if (cAmPM == Calendar.AM) {
							dayChanged = true;
						}
					}
					if (dayChanged) {
						end.add(Calendar.DAY_OF_MONTH, 1);
					}
					if (c.getTime().after(start.getTime()) && c.getTime().before(end.getTime())) {
						return schedule;
					}
				} catch (Exception e) {
					PosLog.error(OutdoorDoctorScheduleUtil.class, e.getMessage());
				}
			}
			avaiableSchedules.sort((o1, o2) -> {
				try {
					return simpleDateFormat.parse(o1.getStartTime()).compareTo(simpleDateFormat.parse(o2.getStartTime()));
				} catch (ParseException e) {
				}
				return 0;
			});
			return avaiableSchedules.get(0);
		}
		return null;
	}

	public static boolean hasSchedule(DoctorTimeSchedule schedule, Date selectedDate) {
		if (!schedule.getActive()) {
			return false;
		}
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(selectedDate);
		int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
		List<Integer> appointmentDays = schedule.getDays();
		return appointmentDays.contains(dayOfWeek);
	}
}
