/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

import com.floreantpos.model.User;

public class SalesBalanceReport {
	private Date fromDate;
	private Date toDate;
	private Date reportTime;
	private User user;

	private double netTaxableSalesAmount;
	private double netNonTaxableSalesAmount;
	private double discountAmount;
	private double grossSalesAmount;
	private double salesTaxAmount;
	private double advanceReceipt;
	private double advanceAdjustmentReceipt;
	private double netSalesAmount;
	private double payInsAmount;
	private double cashTipsAmount;
	private double chargedTipsAmount;
	private double netReceivableAmount;
	private double cashReceiptsAmount;
	private double creditCardReceiptsAmount;
	private double debitCardReceiptsAmount;
	private double customPaymentAmount;
	private double refundAmount;
	private double cashRefundAmount;
	private double otherRefundAmount;
	private double receiptDiffAmount;
	private double grossTipsPaidAmount;
	private double cashPayoutAmount;
	private double cashAccountableAmount;
	private double totalOtherAccountableAmount;
	private double cashInAmount;
	private double coCurrentAmount;
	private double coPreviousAmount;
	private double overShortAmount;
	private double memberPaymentAmount;

	private double visaCreditCardAmount;
	private double masterCardAmount;
	private double amexAmount;
	private double discoveryAmount;
	private double visaDebitCardAmount;
	private double masterDebitCardAmount;
	private double giftCertReceipts;
	private double serviceChargeAmnt;
	private double deliveryChargeAmnt;
	private double gratuity;
	private double feeAmnt;
	private double toleranceAmount;
	private double returnAmount;
	private double dueCollection;
	private double dueAmount;
	private double refundableAmount;
	private double roundAmount;
	private double othersCardAmount;

	private double labDoctorFeeAmount;
	private double agentFeeAmount;

	private double totalOtherReceiptsAmount;
	private double lDFCashAmount;
	private double lDFDueCashAmount;
	private double lDFOtherAmount;
	private double lDFDueOtherAmount;
	private double rFCashAmount;
	private double rFDueCashAmount;
	private double rFOtherAmount;
	private double rFDueOtherAmount;

	public double getCashAccountableAmount() {
		return cashAccountableAmount;
	}

	public void setCashAccountableAmount(double cashAccountableAmount) {
		this.cashAccountableAmount = cashAccountableAmount;
	}

	public double getTotalOtherAccountableAmount() {
		return totalOtherAccountableAmount;
	}

	public void setTotalOtherAccountableAmount(double totalOtherAccountableAmount) {
		this.totalOtherAccountableAmount = totalOtherAccountableAmount;
	}

	public double getRefundAmount() {
		return refundAmount;
	}

	public void setRefundAmount(double cashBackAmount) {
		this.refundAmount = cashBackAmount;
	}

	public double getCashPayoutAmount() {
		return cashPayoutAmount;
	}

	public void setCashPayoutAmount(double cashPayoutAmount) {
		this.cashPayoutAmount = cashPayoutAmount;
	}

	public double getCashReceiptsAmount() {
		return cashReceiptsAmount;
	}

	public void setCashReceiptsAmount(double cashReceiptsAmount) {
		this.cashReceiptsAmount = cashReceiptsAmount;
	}

	public double getChargedTipsAmount() {
		return chargedTipsAmount;
	}

	public void setChargedTipsAmount(double chargedTipsAmount) {
		this.chargedTipsAmount = chargedTipsAmount;
	}

	public double getCoCurrentAmount() {
		return coCurrentAmount;
	}

	public void setCoCurrentAmount(double coCurrentAmount) {
		this.coCurrentAmount = coCurrentAmount;
	}

	public double getCoPreviousAmount() {
		return coPreviousAmount;
	}

	public void setCoPreviousAmount(double coPreviousAmount) {
		this.coPreviousAmount = coPreviousAmount;
	}

	public double getCreditCardReceiptsAmount() {
		return creditCardReceiptsAmount;
	}

	public void setCreditCardReceiptsAmount(double creditCardReceiptsAmount) {
		this.creditCardReceiptsAmount = creditCardReceiptsAmount;
	}

	public double getDiscountAmount() {
		return discountAmount;
	}

	public void setDiscountAmount(double discountAmount) {
		this.discountAmount = discountAmount;
	}

	public Date getFromDate() {
		return fromDate;
	}

	public void setFromDate(Date fromDate) {
		this.fromDate = fromDate;
	}

	public double getNetNonTaxableSalesAmount() {
		return netNonTaxableSalesAmount;
	}

	public void setNetNonTaxableSalesAmount(double grossNonTaxableSalesAmount) {
		this.netNonTaxableSalesAmount = grossNonTaxableSalesAmount;
	}

	public double getNetReceivableAmount() {
		return netReceivableAmount;
	}

	public void setNetReceivableAmount(double netReceivableAmount) {
		this.netReceivableAmount = netReceivableAmount;
	}

	public double getNetTaxableSalesAmount() {
		return netTaxableSalesAmount;
	}

	public void setNetTaxableSalesAmount(double grossTaxableSalesAmount) {
		this.netTaxableSalesAmount = grossTaxableSalesAmount;
	}

	public double getGrossTipsPaidAmount() {
		return grossTipsPaidAmount;
	}

	public void setGrossTipsPaidAmount(double grossTipsPaidAmount) {
		this.grossTipsPaidAmount = grossTipsPaidAmount;
	}

	public double getGrossSalesAmount() {
		return grossSalesAmount;
	}

	public void setGrossSalesAmount(double grossSalesAmount) {
		this.grossSalesAmount = grossSalesAmount;
	}

	public double getOverShortAmount() {
		return overShortAmount;
	}

	public void setOverShortAmount(double overShortAmount) {
		this.overShortAmount = overShortAmount;
	}

	public double getPayInsAmount() {
		return payInsAmount;
	}

	public void setPayInsAmount(double payInsAmount) {
		this.payInsAmount = payInsAmount;
	}

	public double getReceiptDiffAmount() {
		return receiptDiffAmount;
	}

	public void setReceiptDiffAmount(double receiptDiffAmount) {
		this.receiptDiffAmount = receiptDiffAmount;
	}

	public Date getReportTime() {
		return reportTime;
	}

	public void setReportTime(Date reportTime) {
		this.reportTime = reportTime;
	}

	public double getSalesTaxAmount() {
		return salesTaxAmount;
	}

	public void setSalesTaxAmount(double salesTaxAmount) {
		this.salesTaxAmount = salesTaxAmount;
	}

	public double getAdvanceReceipt() {
		return advanceReceipt;
	}

	public void setAdvanceReceipt(double advanceReceipt) {
		this.advanceReceipt = advanceReceipt;
	}

	public double getAdvanceAdjustmentReceipt() {
		return advanceAdjustmentReceipt;
	}

	public void setAdvanceAdjustmentReceipt(double advanceAdjustmentReceipt) {
		this.advanceAdjustmentReceipt = advanceAdjustmentReceipt;
	}

	public Date getToDate() {
		return toDate;
	}

	public void setToDate(Date toDate) {
		this.toDate = toDate;
	}

	public double getNetSalesAmount() {
		return netSalesAmount;
	}

	public void setNetSalesAmount(double netSalesAmount) {
		this.netSalesAmount = netSalesAmount;
	}

	public void calculateOld() {
		netSalesAmount = grossSalesAmount - discountAmount + salesTaxAmount + serviceChargeAmnt;
		netReceivableAmount = netSalesAmount + payInsAmount + cashTipsAmount + chargedTipsAmount;
		receiptDiffAmount = netReceivableAmount - cashReceiptsAmount - creditCardReceiptsAmount - debitCardReceiptsAmount - customPaymentAmount + refundAmount
				- memberPaymentAmount + toleranceAmount;
		cashAccountableAmount = cashReceiptsAmount - grossTipsPaidAmount - cashPayoutAmount - cashRefundAmount;
		overShortAmount = cashAccountableAmount - coCurrentAmount + coPreviousAmount;

	}

	public void calculate() {
		//double todaysReceivable = grossSalesAmount - discountAmount;
		netSalesAmount = grossSalesAmount - discountAmount + salesTaxAmount + advanceReceipt - advanceAdjustmentReceipt;
		netReceivableAmount = netSalesAmount + serviceChargeAmnt + deliveryChargeAmnt + payInsAmount + gratuity + feeAmnt;
		double totalReceiptAmount = cashReceiptsAmount + creditCardReceiptsAmount + debitCardReceiptsAmount + customPaymentAmount + giftCertReceipts
				+ memberPaymentAmount;
		dueAmount = netReceivableAmount - totalReceiptAmount + dueCollection;
		refundableAmount = returnAmount - refundAmount;

		receiptDiffAmount = netReceivableAmount - totalReceiptAmount - returnAmount + refundableAmount + refundAmount + roundAmount + toleranceAmount
				+ dueCollection - dueAmount;

		BigDecimal bigDecimal = new BigDecimal(String.valueOf(Math.abs(receiptDiffAmount)));
		bigDecimal = bigDecimal.setScale(2, RoundingMode.FLOOR);
		double doubleValue = bigDecimal.doubleValue();
		if (doubleValue == 0) {
			receiptDiffAmount = 0;
		}

		cashAccountableAmount = cashReceiptsAmount - grossTipsPaidAmount - cashPayoutAmount - cashRefundAmount - rFCashAmount - rFDueCashAmount - lDFCashAmount
				- lDFDueCashAmount;

		overShortAmount = cashAccountableAmount - coCurrentAmount + coPreviousAmount;

		totalOtherReceiptsAmount = creditCardReceiptsAmount + debitCardReceiptsAmount + customPaymentAmount + giftCertReceipts + memberPaymentAmount;
		totalOtherAccountableAmount = totalOtherReceiptsAmount - (rFOtherAmount + rFDueOtherAmount + lDFOtherAmount + lDFDueOtherAmount) - otherRefundAmount;

	}

	public double getVisaCreditCardAmount() {
		return visaCreditCardAmount;
	}

	public void setVisaCreditCardAmount(double visaCreditCardAmount) {
		this.visaCreditCardAmount = visaCreditCardAmount;
	}

	public double getMasterCardAmount() {
		return masterCardAmount;
	}

	public void setMasterCardAmount(double masterCardAmount) {
		this.masterCardAmount = masterCardAmount;
	}

	public double getAmexAmount() {
		return amexAmount;
	}

	public void setAmexAmount(double amexAmount) {
		this.amexAmount = amexAmount;
	}

	public double getDiscoveryAmount() {
		return discoveryAmount;
	}

	public void setDiscoveryAmount(double discoveryAmount) {
		this.discoveryAmount = discoveryAmount;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public double getDebitCardReceiptsAmount() {
		return debitCardReceiptsAmount;
	}

	public void setDebitCardReceiptsAmount(double debitCardReceiptsAmount) {
		this.debitCardReceiptsAmount = debitCardReceiptsAmount;
	}

	public double getCustomPaymentAmount() {
		return customPaymentAmount;
	}

	public void setCustomPaymentAmount(double customPaymentAmount) {
		this.customPaymentAmount = customPaymentAmount;
	}

	public double getCashTipsAmount() {
		return cashTipsAmount;
	}

	public void setCashTipsAmount(double cashTipsAmount) {
		this.cashTipsAmount = cashTipsAmount;
	}

	public double getGiftCertReceipts() {
		return giftCertReceipts;
	}

	public void setGiftCertReceipts(double giftCertReceipts) {
		this.giftCertReceipts = giftCertReceipts;
	}

	public double getCashRefundAmount() {
		return cashRefundAmount;
	}

	public void setCashRefundAmount(double cashRefundAmount) {
		this.cashRefundAmount = cashRefundAmount;
	}

	public double getMemberPaymentAmount() {
		return memberPaymentAmount;
	}

	public void setMemberPaymentAmount(double memberPaymentAmount) {
		this.memberPaymentAmount = memberPaymentAmount;
	}

	public double getServiceChargeAmnt() {
		return serviceChargeAmnt;
	}

	public void setServiceChargeAmnt(double serviceChargeAmnt) {
		this.serviceChargeAmnt = serviceChargeAmnt;
	}

	public double getDeliveryChargeAmnt() {
		return deliveryChargeAmnt;
	}

	public void setDeliveryChargeAmnt(double deliveryChargeAmnt) {
		this.deliveryChargeAmnt = deliveryChargeAmnt;
	}

	public double getGratuity() {
		return gratuity;
	}

	public void setGratuity(double gratuity) {
		this.gratuity = gratuity;
	}

	public double getFeeAmnt() {
		return feeAmnt;
	}

	public void setFeeAmnt(double feeAmnt) {
		this.feeAmnt = feeAmnt;
	}

	public double getToleranceAmount() {
		return toleranceAmount;
	}

	public void setToleranceAmount(double toleranceAmount) {
		this.toleranceAmount = toleranceAmount;
	}

	public double getVisaDebitCardAmount() {
		return visaDebitCardAmount;
	}

	public void setVisaDebitCardAmount(double visaDebitCardAmount) {
		this.visaDebitCardAmount = visaDebitCardAmount;
	}

	public double getMasterDebitCardAmount() {
		return masterDebitCardAmount;
	}

	public void setMasterDebitCardAmount(double masterDebitCardAmount) {
		this.masterDebitCardAmount = masterDebitCardAmount;
	}

	public double getReturnAmount() {
		return returnAmount;
	}

	public void setReturnAmount(double returnAmount) {
		this.returnAmount = returnAmount;
	}

	public double getCashInAmount() {
		return cashInAmount;
	}

	public void setCashInAmount(double cashInAmount) {
		this.cashInAmount = cashInAmount;
	}

	public double getRoundedAmount() {
		return roundAmount;
	}

	public void setRoundAmount(double roundAmount) {
		this.roundAmount = roundAmount;
	}

	public double getOthersCardAmount() {
		return othersCardAmount;
	}

	public void setOthersCardAmount(double othersCardAmount) {
		this.othersCardAmount = othersCardAmount;
	}

	public double getLabDoctorFeeAmount() {
		return labDoctorFeeAmount;
	}

	public void setLabDoctorFeeAmount(double labDoctorFeeAmount) {
		this.labDoctorFeeAmount = labDoctorFeeAmount;
	}

	public double getAgentFeeAmount() {
		return agentFeeAmount;
	}

	public void setAgentFeeAmount(double agentFeeAmount) {
		this.agentFeeAmount = agentFeeAmount;
	}

	public double getDueCollection() {
		return dueCollection;
	}

	public void setDueCollection(double dueCollection) {
		this.dueCollection = dueCollection;
	}

	public double getDueAmount() {
		return dueAmount;
	}

	public void setDueAmount(double dueAmount) {
		this.dueAmount = dueAmount;
	}

	public double getRefundableAmount() {
		return refundableAmount;
	}

	public void setRefundableAmount(double refundableAmount) {
		this.refundableAmount = refundableAmount;
	}

	public double getTotalOtherReceiptsAmount() {
		return totalOtherReceiptsAmount;
	}

	public void setTotalOtherReceiptsAmount(double totalOtherReceiptsAmount) {
		this.totalOtherReceiptsAmount = totalOtherReceiptsAmount;
	}

	public double getlDFCashAmount() {
		return lDFCashAmount;
	}

	public void setlDFCashAmount(double lDFCashAmount) {
		this.lDFCashAmount = lDFCashAmount;
	}

	public double getlDFOtherAmount() {
		return lDFOtherAmount;
	}

	public void setlDFOtherAmount(double lDFOtherAmount) {
		this.lDFOtherAmount = lDFOtherAmount;
	}

	public double getrFCashAmount() {
		return rFCashAmount;
	}

	public void setrFCashAmount(double rFCashAmount) {
		this.rFCashAmount = rFCashAmount;
	}

	public double getrFOtherAmount() {
		return rFOtherAmount;
	}

	public void setrFOtherAmount(double rFOtherAmount) {
		this.rFOtherAmount = rFOtherAmount;
	}

	public double getlDFDueCashAmount() {
		return lDFDueCashAmount;
	}

	public void setlDFDueCashAmount(double lDFDueCashAmount) {
		this.lDFDueCashAmount = lDFDueCashAmount;
	}

	public double getlDFDueOtherAmount() {
		return lDFDueOtherAmount;
	}

	public void setlDFDueOtherAmount(double lDFDueOtherAmount) {
		this.lDFDueOtherAmount = lDFDueOtherAmount;
	}

	public double getrFDueCashAmount() {
		return rFDueCashAmount;
	}

	public void setrFDueCashAmount(double rFDueCashAmount) {
		this.rFDueCashAmount = rFDueCashAmount;
	}

	public double getrFDueOtherAmount() {
		return rFDueOtherAmount;
	}

	public void setrFDueOtherAmount(double rFDueOtherAmount) {
		this.rFDueOtherAmount = rFDueOtherAmount;
	}

	public double getOtherRefundAmount() {
		return otherRefundAmount;
	}

	public void setOtherRefundAmount(double otherRefundAmount) {
		this.otherRefundAmount = otherRefundAmount;
	}

}
