package com.floreantpos.util;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.dao.MenuItemDAO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.orocube.rest.service.JsonBeanFieldExcluder;

public class DefaultOTDataInserter {

	public DefaultOTDataInserter() {
	}

	public void insert() {
		Transaction transaction = null;
		try (Session session = MenuItemDAO.getInstance().createNewSession()) {
			transaction = session.beginTransaction();

			List<MenuItem> oTMenuItems = defaultOTMenuItemData();
			for (MenuItem otMenuItem : oTMenuItems) {
				otMenuItem.setProductType(ProductType.OT.name());
				MenuItemDAO.getInstance().save(otMenuItem, session);
			}

			transaction.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	private static List<MenuItem> defaultOTMenuItemData() {
		List<MenuItem> oTMenuItems = Collections.emptyList();

		String fileName = "/SurgeryList.json";
		try (InputStream resourceAsStream = DefaultOTDataInserter.class.getResourceAsStream(fileName)) { //$NON-NLS-1$
			if (resourceAsStream != null) {

				Type listType = new TypeToken<ArrayList<MenuItem>>() {
				}.getType();

				Gson gson = new GsonBuilder().setExclusionStrategies(new JsonBeanFieldExcluder(MenuShift.class)).create();
				oTMenuItems = gson.fromJson(IOUtils.toString(resourceAsStream), listType);
			}
		} catch (Exception e) {
			PosLog.error(DefaultOTDataInserter.class, e);
		}
		return oTMenuItems;
	}

}
