package com.floreantpos.model.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.OnlineGroup;

public class OnlineGroupDAO extends BaseOnlineGroupDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public OnlineGroupDAO() {
	}

	public OnlineGroup findByMenuGroupId(String groupId) {
		try (Session session = createNewSession()) {
			return findByMenuGroupId(groupId, session);
		}
	}

	public OnlineGroup findByMenuGroupId(String groupId, Session session) {
		Criteria criteria = session.createCriteria(getReferenceClass());
		criteria.add(Restrictions.eq(OnlineGroup.PROP_GROUPD_ID, groupId));
		criteria.setMaxResults(1);
		return (OnlineGroup) criteria.uniqueResult();
	}
}