package com.floreantpos.report.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.report.LabDoctorFeeReportData;
import com.floreantpos.swing.ListTableModel;

public class LabDoctorFeeReportModel extends ListTableModel {
	private boolean isShowDetailReport;

	public LabDoctorFeeReportModel() {
		super(new String[] { "labDoctorName", "orderId", "orderDate", "patientName", "testName", "labDoctorFee", "labDoctorPaid", "labDoctorDue", "labDoctorId",
				"patientId" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		LabDoctorFeeReportData reportData = (LabDoctorFeeReportData) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return reportData.getLabDoctorName();

			case 1:
				return isShowDetailReport ? reportData.getOrderId() : StringUtils.EMPTY;

			case 2:
				return isShowDetailReport ? reportData.getOrderDateDisplay() : StringUtils.EMPTY;

			case 3:
				return isShowDetailReport ? reportData.getPatientName() : StringUtils.EMPTY;

			case 4:
				return isShowDetailReport ? reportData.getTestName() : StringUtils.EMPTY;

			case 5:
				return reportData.getLabDoctorFee();

			case 6:
				return reportData.getLabDoctorFeePaidAmount();

			case 7:
				return reportData.getLabDoctorFeeDueAmount();

			case 8:
				return reportData.getLabDoctorId();

			case 9:
				return isShowDetailReport ? reportData.getPatientId() : StringUtils.EMPTY;

		}
		return null;
	}

	public void setIsShowDetail(boolean isShowDetailReport) {
		this.isShowDetailReport = isShowDetailReport;

	}

}