package com.floreantpos.report.model;

import com.floreantpos.model.SalaryTransaction;
import com.floreantpos.swing.ListTableModel;

public class SalaryPaymentsReportModel extends ListTableModel {
	public SalaryPaymentsReportModel() {
		super(new String[] { "userId", "userName", "eventTime", "salary", "amount", "advanceBack", "deduction", "note" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		SalaryTransaction reportData = (SalaryTransaction) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return reportData.getUserId();
				
			case 1:
				return reportData.getUserName();
				
			case 2:
				return reportData.getEventTimeDisplay();
				
			case 3:
				return reportData.getEmployeeMonthlySalaryAmount();
				
			case 4:
				return reportData.getAmount();
				
			case 5:
				return reportData.getAdvanceBackAmount();
				
			case 6:
				return reportData.getTotalDeductionAmount();
				
			case 7:
				return reportData.getNote();

		}
		return null;
	}

}