/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.ReportType;
import com.floreantpos.model.TestItem;
import com.floreantpos.model.TestItemGroup;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TestItemGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListTableModel;

public class LabTestResultReportModel extends ListTableModel<TestItem> {

	private TicketItem ticketItem;

	public LabTestResultReportModel(TicketItem ticketItem) {
		super(new String[] { "itemName", "testResult", "unitName", "referenceValue", "approveResultNote", "testCategoryName", "reportDescription" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
		this.ticketItem = ticketItem;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		TestItem labTestItem = (TestItem) rows.get(rowIndex);
		String testItemGroupId = labTestItem.getTestItemGroupId();

		switch (columnIndex) {
			case 0:
				Outlet outlet = DataProvider.get().getOutlet();
				if (outlet.isShowGroupInReport()) {
					if (testItemGroupId.equals("1234")) { //$NON-NLS-1$
						return "  " + labTestItem.getName().trim(); //$NON-NLS-1$
					}
				}
				else {
					return labTestItem.getName().trim();
				}

			case 1:
				String reportType = ticketItem.getReportType();
				String testResult;
				if (reportType.equals(ReportType.PLAIN_REPORT.name())) {
					testResult = labTestItem.getHTMLResult();
					if (StringUtils.isBlank(testResult)) {
						testResult = labTestItem.getResult();
					}
				}
				else {
					testResult = labTestItem.getResult();
				}
				//				if (reportType.equals(ReportType.PLAIN_TABULAR_REPORT.name())|| reportType.equals(ReportType.POSITIVE_NEGATIVE.name())) {
				//					return StringUtils.isBlank(testResult) ? "Pending" : testResult.trim();
				//				}
				return StringUtils.isBlank(testResult) ? "Pending" : testResult.trim() + " " + labTestItem.getUnitName().trim();

			case 2:
				return labTestItem.getUnitName().trim();

			case 3:
				String normalValue = labTestItem.getNormalValue();
				if (normalValue != null) {
					normalValue = normalValue.replaceAll("\n", "<br/>");
				}
				return normalValue;

			case 4:
				return labTestItem.getApprovedNote();

			case 5:
				if (StringUtils.isNotBlank(testItemGroupId)) {
					if (testItemGroupId.equals("1234")) { //$NON-NLS-1$
						return "Blood"; //$NON-NLS-1$
					}

					TestItemGroup testItemGroup = TestItemGroupDAO.getInstance().get(testItemGroupId);
					return testItemGroup.getName();
				}
				return ""; //$NON-NLS-1$

			case 6:
				String approvedNote = labTestItem.getApprovedNote();
				if (StringUtils.isBlank(approvedNote)) {
					approvedNote = ticketItem.getReportDescription();
				}
				return approvedNote;

		}
		return null;
	}

}
