/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report.model;

import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.swing.ListTableModel;

public class BankAccountTransactionReportDataModel extends ListTableModel {

	public BankAccountTransactionReportDataModel() {
		setColumnNames(new String[] { "date", "note", "transactionReason", "amount", "orderOrEmployeeId" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		BalanceUpdateTransaction data = (BalanceUpdateTransaction) rows.get(rowIndex);

		switch (columnIndex) {

			case 0:
				return data.getTransactionTimeDisplay();

			case 1:
				return data.getNoteDisplay();

			case 2:
				return data.getDescriptionDisplay();

			case 3:
				return data.getAmount();

			case 4:
				return data.getOrderIdOrEmployeeId();

		}
		return null;
	}

}
