package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the SEQUENCE_NUMBER table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="SEQUENCE_NUMBER"
 */

public abstract class BaseSequenceNumber  implements Comparable, Serializable {

	public static String REF = "SequenceNumber"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_SEQUENCE_DATE = "sequenceDate"; //$NON-NLS-1$
	public static String PROP_NEXT_SEQUENCE_NUMBER = "nextSequenceNumber"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseSequenceNumber () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseSequenceNumber (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseSequenceNumber (
		java.lang.String id,
		java.lang.String type) {

		this.setId(id);
		this.setType(type);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String type;
				private java.lang.String sequenceDate;
				private java.lang.Integer nextSequenceNumber;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.String getType () {
			return type;
	}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.String type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: SEQUENCE_Date
	 */

	public java.lang.String getSequenceDate () {
			return sequenceDate;
	}



	/**
	 * Set the value related to the column: SEQUENCE_Date
	 * @param sequenceDate the SEQUENCE_Date value
	 */
			public void setSequenceDate (java.lang.String sequenceDate) {
			this.sequenceDate = sequenceDate;
	}



	/**
	 * Return the value associated with the column: NEXT_SEQUENCE_NUMBER
	 */

	public java.lang.Integer getNextSequenceNumber () {
						return nextSequenceNumber == null ? Integer.valueOf(0) : nextSequenceNumber;
		}



	/**
	 * Set the value related to the column: NEXT_SEQUENCE_NUMBER
	 * @param nextSequenceNumber the NEXT_SEQUENCE_NUMBER value
	 */
			public void setNextSequenceNumber (java.lang.Integer nextSequenceNumber) {
			this.nextSequenceNumber = nextSequenceNumber;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.SequenceNumber)) return false;
		else {
			com.floreantpos.model.SequenceNumber sequenceNumber = (com.floreantpos.model.SequenceNumber) obj;
			if (null == this.getId() || null == sequenceNumber.getId()) return this == obj;
			else return (this.getId().equals(sequenceNumber.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}