/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report.model;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.floreantpos.services.report.CashDrawerDetailReport;

public class CashDrawerDetailReportModel extends AbstractTableModel {
	protected List<CashDrawerDetailReport> rows;

	private String[] columnNames = { "transTime", "invoiceId", "transactionAmount", "invoiceDate", "paymentType", "name", "voidBy" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

	public CashDrawerDetailReportModel() {
		super();
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		CashDrawerDetailReport transction = (CashDrawerDetailReport) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return transction.getTransTimeDisplay();

			case 1:
				return transction.getTicketId();

			case 2:
				return transction.getTransactionAmount();

			case 3:
				return transction.getInvoiceDate();

			case 4:
				return transction.getPaymentType();
		}
		return null;
	}

	public int getRowCount() {
		if (rows == null) {
			return 0;
		}

		return rows.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int column) {
		return columnNames[column];
	}

	public List<CashDrawerDetailReport> getItems() {
		return rows;
	}

	public void setItems(List<CashDrawerDetailReport> items) {
		this.rows = items;
	}

}
