package com.floreantpos.extension;

public class PaymentMethod {
	private String id;
	private String accountId;
	private String cardNumber;
	private String cardType;
	private boolean isDefault;
	private String accountHolderName;
	private String expMonth;
	private String expYear;

	public PaymentMethod(String id, String accountId, String cardNumber, String cardType, boolean isDefault) {
		this.id = id;
		this.accountId = accountId;
		if (cardNumber.length() > 4) {
			cardNumber = cardNumber.substring(0, 3);
		}
		this.cardNumber = cardNumber;
		this.cardType = cardType;
		this.isDefault = isDefault;
	}

	public String getAccountId() {
		return accountId;
	}

	public String getCardType() {
		return cardType;
	}

	public String getId() {
		return id;
	}

	@Override
	public String toString() {
		return cardType + " **" + cardNumber + " " + getExpMonth() + "/" + getExpYear(); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	public boolean isDefault() {
		return isDefault;
	}

	public String getAccountHolderName() {
		return accountHolderName;
	}

	public void setAccountHolderName(String accountHolderName) {
		this.accountHolderName = accountHolderName;
	}

	public String getExpMonth() {
		return expMonth;
	}

	public void setExpMonth(String expMonth) {
		if (expMonth != null && expMonth.length() == 1) {
			expMonth = "0" + expMonth; //$NON-NLS-1$
		}
		this.expMonth = expMonth;
	}

	public String getExpYear() {
		return expYear;
	}

	public void setExpYear(String expYear) {
		this.expYear = expYear;
	}
}