package com.floreantpos.hl7.astm;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;

import com.floreantpos.PosLog;
import com.floreantpos.hl7.HL7Util;
import com.floreantpos.hl7.model.Result;
import com.floreantpos.hl7.model.Test;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.util.DataProvider;

public class AstmParser {

	public static Test parseAstmMessage(Session session, String storeId, String astmMessage, Map<String, InventoryUnit> unitsMap) throws Exception {
		return parseAstmMessage(session, storeId, astmMessage, unitsMap, false);
	}

	public static Test parseAstmMessage(Session session, String storeId, String astmMessage, Map<String, InventoryUnit> unitsMap, boolean readSampleIDFromPBlock) throws Exception {
		String regex = "(?:^(R)\\|(\\d+)\\|\\^*([^|]*)\\|([^|]*)\\|(?:([^|]*)\\|)?.*$)|(?:^(P)\\|(\\d+)\\|\\|\\|(\\d*)?.*$)|(?:^(O)\\|(\\d+)\\|\\|\\^*\\s*(\\d+)\\^\\w.*$)|(?:^(H)\\|\\\\\\^&\\|*([\\s*\\w\\-*\\d]*)\\^*.*$)";

		final Pattern pattern = Pattern.compile(regex, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE);
		final Matcher matcher = pattern.matcher(astmMessage);

		Test test = new Test();
		while (matcher.find()) {

			if (matcher.group(12) != null && matcher.group(12).equals("H")) {
				test.machine = StringUtils.isNotBlank(matcher.group(13)) ? matcher.group(13).trim() : "";
			}
			else {
				if (matcher.group(6) != null && matcher.group(6).equalsIgnoreCase("P")) {
					if (readSampleIDFromPBlock) {
						test.sampleId = matcher.group(8);
						PosLog.debug(AstmParser.class, "Sample ID From Patient Block: " + test.sampleId);
					}
					test.patientId = matcher.group(7);

					PosLog.debug(AstmParser.class, "Patient ID: " + test.patientId);
				}
				else if (matcher.group(9) != null && matcher.group(9).equalsIgnoreCase("O")) {
					if (!readSampleIDFromPBlock) {
						test.sampleId = matcher.group(11);
						PosLog.debug(AstmParser.class, "Sample ID From order Block:  " + test.sampleId);
					}

				}
				else if (matcher.group(1) != null && matcher.group(1).equalsIgnoreCase("R")) {
					Result result = new Result();
					result.resultNo = matcher.group(2);
					result.testName = HL7Util.cleanTestName(matcher.group(3));
					result.result = matcher.group(4);
					result.unit = matcher.group(5);
					String unitName = result.unit;
					
					HL7Util hl7Util = new HL7Util(session, storeId, DataProvider.get().getOutletId());

					hl7Util.updateUnit(unitsMap, result, unitName);

					test.resultmap.put(result.testName, result);

					PosLog.debug(AstmParser.class,
							String.format("Result no: %s, name=%s, value: %s, unit: %s", result.resultNo, result.testName, result.result, result.unit));
				}
			}
		}

		return test;
	}

	public static void main(String[] args) {
		//		List<Test> saveResult = saveResult(getSampleMachineData());
		//		System.out.println(saveResult.size());
	}

	//@formatter:off
	public static String getSampleMachineData() {
		return "H|\\^&|||XP-100^00-13^^^^A7355^BS649542||||||||E1394-97\r\n" + 
				"P|1\r\n" + 
				"O|1||^^          05146^A|^^^^WBC\\^^^^RBC\\^^^^HGB\\^^^^HCT\\^^^^MCV\\^^^^MCH\\^^^^MCHC\\^^^^PLT\\^^^^LYM%\\^^^^MXD%\\^^^^NEUT%\\^^^^LYM#\\^^^^MXD#\\^^^^NEUT#\\^^^^RDW-SD\\^^^^RDW-CV\\^^^^PDW\\^^^^MPV\\^^^^P-LCR\\^^^^PCT|||||||N||||||||||||||F\r\n" + 
				"R|1|^^^^WBC^1| 16.7|10*3/uL||H||||               ||20240205132426\r\n" + 
				"R|2|^^^^RBC^1| 4.27|10*6/uL||N||||               ||20240205132426\r\n" + 
				"R|3|^^^^HGB^1| 12.1|g/dL||N||||               ||20240205132426\r\n" + 
				"R|4|^^^^HCT^1| 33.6|%||N||||               ||20240205132426\r\n" + 
				"R|5|^^^^MCV^1| 78.7|fL||L||||               ||20240205132426\r\n" + 
				"R|6|^^^^MCH^1| 28.3|pg||N||||               ||20240205132426\r\n" + 
				"R|7|^^^^MCHC^1| 36.0|g/dL||N||||               ||20240205132426\r\n" + 
				"R|8|^^^^PLT^1|  281|10*3/uL||W||||               ||20240205132426\r\n" + 
				"R|9|^^^^LYM%^1| 12.7|%||N||||               ||20240205132426\r\n" + 
				"R|10|^^^^MXD%^1| 16.2|%||N||||               ||20240205132426\r\n" + 
				"R|11|^^^^NEUT%^1| 71.1|%||N||||               ||20240205132426\r\n" + 
				"R|12|^^^^LYM#^1|  2.1|10*3/uL||N||||               ||20240205132426\r\n" + 
				"R|13|^^^^MXD#^1|  2.7|10*3/uL||N||||               ||20240205132426\r\n" + 
				"R|14|^^^^NEUT#^1| 11.9|10*3/uL||N||||               ||20240205132426\r\n" + 
				"R|15|^^^^RDW-SD^1| 43.6|fL||N||||               ||20240205132426\r\n" + 
				"R|16|^^^^RDW-CV^1| 15.3|%||N||||               ||20240205132426\r\n" + 
				"R|17|^^^^PDW^1| 10.7|fL||N||||               ||20240205132426\r\n" + 
				"R|18|^^^^MPV^1| 10.1|fL||N||||               ||20240205132426\r\n" + 
				"R|19|^^^^P-LCR^1| 25.0|%||N||||               ||20240205132426\r\n" + 
				"R|20|^^^^PCT^1| 0.28|%||W||||               ||20240205132426\r\n" + 
				"L|1|N\r\n" + 
				"";

	}
	//@formatter:on
}
