package com.floreantpos.util;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

public class GsonUtil {

	public static Gson createGson() {
		return createGson(new GsonBuilder());
	}

	public static Gson createGson(GsonBuilder builder) {
		//@formatter:off
		ExclusionStrategy strategy = new ExclusionStrategy() {
			@Override
			public boolean shouldSkipField(FieldAttributes f) {
				if (f.getName().equals("hashCode")) { //$NON-NLS-1$
					return true;
				}
				return false;
			}

			@Override
			public boolean shouldSkipClass(Class<?> clazz) {
				return false;
			}
			
		};
		
		Gson gson = builder
				.addSerializationExclusionStrategy(strategy)
				.setDateFormat("E MMM dd HH:mm:ss Z yyyy") //$NON-NLS-1$
				.create();
		//@formatter:on
		return gson;
	}

	public static <T> List<T> convertJSONToList(String gsonString, Class<T> clazz) {
		if (StringUtils.isNotBlank(gsonString)) {
			Type listType = TypeToken.getParameterized(List.class, clazz).getType();
			return createGson().fromJson(gsonString, listType);
		}
		return new ArrayList<>();
	}

	public static <T> Set<T> convertJSONToSet(String gsonString, Class<T> clazz) {
		if (StringUtils.isNotBlank(gsonString)) {
			Type listType = TypeToken.getParameterized(Set.class, clazz).getType();
			return createGson().fromJson(gsonString, listType);
		}
		return new HashSet<>();
	}

	public static Gson createGson(String... skipFields) {
		//@formatter:off
		ExclusionStrategy strategy = new ExclusionStrategy() {
			@Override
			public boolean shouldSkipField(FieldAttributes f) {
				if (f.getName().equals("hashCode")) { //$NON-NLS-1$
					return true;
				}
				if (skipFields != null && skipFields.length > 0) {
					for (String skipField : skipFields) {
						if (f.getName().equals(skipField)) {
							return true;
						}
					}
				}
				return false;
			}

			@Override
			public boolean shouldSkipClass(Class<?> clazz) {
				return false;
			}
		};
		
		Gson gson = new GsonBuilder()
				.addSerializationExclusionStrategy(strategy)
				.setDateFormat("E MMM dd HH:mm:ss Z yyyy") //$NON-NLS-1$
				.create();
		//@formatter:on
		return gson;
	}

}
