package com.floreantpos.model;

import com.floreantpos.util.NumberUtil;

public class SurgeryEquipmentItem {

	private String equipmentId;
	private String equipmentName;
	private String status;
	private String unitId;
	private Double quantity;

	private transient MenuItem equipment;
	private transient IUnit unit;

	public SurgeryEquipmentItem() {
	}

	public String getEquipmentId() {
		return equipmentId;
	}

	public void setEquipmentId(String equipmentId) {
		this.equipmentId = equipmentId;
	}

	public String getEquipmentName() {
		return equipmentName;
	}

	public void setEquipmentName(String equipmentName) {
		this.equipmentName = equipmentName;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public MenuItem getEquipment() {
		return equipment;
	}

	public void setEquipment(MenuItem equipment) {
		this.equipment = equipment;
	}

	@Override
	public String toString() {
		return getEquipmentNameDisplay();
	}

	public String getUnitId() {
		return unitId;
	}

	public void setUnitId(String equipmentUnit) {
		this.unitId = equipmentUnit;
	}

	public Double getQuantity() {
		return quantity == null ? 1D : quantity;
	}

	public void setQuantity(Double quantity) {
		this.quantity = quantity;
	}

	public String getEquipmentNameDisplay() {
		//String unitName = getUnitId();
		Double quantity = getQuantity();
		String quantityDisplay = ""; //$NON-NLS-1$
		if (quantity > 1) {
			//if (unitName == null || ("ea".equals(unitName) || ("Each".equals(unitName) || ("piece".equalsIgnoreCase(unitName))))) { //$NON-NLS-1$ //$NON-NLS-2$
			quantityDisplay = NumberUtil.trimDecilamIfNotNeeded(quantity) + "x "; //$NON-NLS-1$
			//}
			///else {
			//	quantityDisplay = NumberUtil.trimDecilamIfNotNeeded(quantity) + "x " + unitName + " "; //$NON-NLS-1$
			//}
		}
		return quantityDisplay + getEquipmentName();
	}

	public IUnit getUnit() {
		return unit;
	}

	public void setUnit(IUnit unit) {
		this.unit = unit;
	}
}
