/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report.model;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;

public class InventoryStockReportDataModel extends ListTableModel<InventoryStock> {

	public InventoryStockReportDataModel() {
		setColumnNames(
				new String[] { "itemName", "sku", "location", "batch", "expiryDate", "unitCost", "totalCost", "unitPrice", "totalPrice", "qty", "unitName" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		InventoryStock data = (InventoryStock) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return data.getItemName();

			case 1:
				return data.getSku();

			case 2:
				return data.getLocationName();

			case 3:
				String batchNumber = data.getBatchNumber();
				if (StringUtils.isBlank(batchNumber)) {
					return StringUtils.EMPTY;
				}
				return batchNumber;

			case 4:
				Date expireDate = data.getExpireDate();
				if (expireDate == null) {
					return StringUtils.EMPTY;
				}
				return DateUtil.formatDateWithoutTime(expireDate);

			case 5:
				return data.getUnitCost();

			case 6:
				return data.getTotalCost();

			case 7:
				return data.getUnitPrice();

			case 8:
				return data.getTotalPrice();

			case 9:
				return data.getQuantityInHand();

			case 10:
				return data.getUnitName();

		}
		return null;
	}

}
