/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.sql.DriverManager;
import java.sql.SQLException;

import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;

public class UpdateDBTo305 {

	private String dbConnectString;
	private String user;
	private String password;
	private String schema;

	public UpdateDBTo305(String dbConnectString, String user, String password, String schema) {
		this.dbConnectString = dbConnectString;
		this.user = user;
		this.password = password;
		this.schema = schema;
	}

	public void update() throws Exception {
		executeLiquibaseUpdate();
	}

	private void executeLiquibaseUpdate() throws SQLException, DatabaseException, LiquibaseException {
		try (java.sql.Connection connection = DriverManager.getConnection(dbConnectString, user, password)) {
			Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
			database.setLiquibaseSchemaName(schema);
			database.setDefaultSchemaName(schema);
			Liquibase liquibase = new liquibase.Liquibase("db-changelog9.xml", new ClassLoaderResourceAccessor(), database); //$NON-NLS-1$
			liquibase.update(new Contexts(), new LabelExpression());
		}
	}
}