package com.floreantpos.model.dao;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.Symptom;
import com.floreantpos.swing.PaginatedListModel;

public class SymptomDAO extends BaseSymptomDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public SymptomDAO() {
	}

	public void loadData(PaginatedListModel<Symptom> tableModel, String name) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(name)) {
				criteria.add(Restrictions.eq(Symptom.PROP_NAME, name));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			tableModel.setData(criteria.list());
		}
	}

	public Symptom saveSymptomIfNeeded(String name) {
		Symptom symptom = findByName(name);
		if (symptom != null) {
			return symptom;
		}
		symptom = new Symptom();
		symptom.setName(name);
		saveOrUpdate(symptom);
		return symptom;
	}

	public Symptom findByName(String name) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Symptom.PROP_NAME, name).ignoreCase());
			criteria.setMaxResults(1);
			return (Symptom) criteria.uniqueResult();
		}
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		Symptom data = (Symptom) obj;
		if (data == null) {
			throw new PosException("Data not found.");
		}
		data.setDeleted(Boolean.TRUE);
		saveOrUpdate(data, session);
	}
}