/**
 * 
 */
package com.floreantpos.model.ext;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 *
 * Marks a field to be set to {@code null} after a Hibernate {@code refresh()} call.
 * 
 * <p>Typical usage:
 * <pre>
 * &#64;ResetAfterRefresh
 * private transient JsonObject propertiesContainer;
 * </pre>
 *
 * Requires custom logic to handle the null assignment.
 * 
 * @author siddiqur
 */
@Retention(RUNTIME)
@Target(FIELD)
public @interface ResetBeforeRefresh {

}
