package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;

public enum ServiceType {
	ANESTHESIA("Anesthesia"),
    ANESTHESIA_GENERAL("General Anesthesia"),
    ANESTHESIA_REGIONAL("Regional Anesthesia"),
    ANESTHESIA_LOCAL("Local Anesthesia"),
    ANESTHESIA_SEDATION("Sedation Anesthesia"),
    OT("OT"),
    BED("Bed"),
    OT_ADMISSION("OT Admission"),
    ADMISSION("Admission"),
    SURGERY("Surgery"),
    SURGERY_ASSIT("Surgery Assit"),
    OT_SERVICE("OT Service"), 
    OT_ASSISTANCE("OT Assistance"),
    OTHER_COST("Other Cost"),
    CONSULTATION_FEE("Consultation fee")
	;

    private final String displayString;

    ServiceType(String displayName) {
        this.displayString = displayName;
    }

    public String getDisplayName() {
        return displayString;
    }

    public static ServiceType fromDisplayName(String name) {
        for (ServiceType type : values()) {
            if (type.displayString.equalsIgnoreCase(name)) {
                return type;
            }
        }
        return null;
    }
    
    @Override
	public String toString() {
		return displayString;
	}
    
    public static boolean match(String serviceTypeName, ServiceType serviceType) {
    	if (StringUtils.isBlank(serviceTypeName)) {
			return false;
		}
		ServiceType service = valueOf(serviceTypeName);
		if (service == null) {
			service = fromDisplayName(serviceTypeName);
		}
		return serviceType == service;
	}

}
