package com.floreantpos.util;

import java.util.Date;

import org.hibernate.Session;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;

public class UserIdGenerator {
	public static String generateUserId() {
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			String currentOutletId = DataProvider.get().getCurrentOutletId();
			String date = SequenceNumber.yearMonthDayFormat.format(new Date());
			
			String userId = date + SequenceNumber.threeDigitDecimalFormat.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.USER_ID_SEQUENCE_NUMBER, date));
			while (UserDAO.getInstance().get(userId, currentOutletId, session) != null) {
				userId = date + SequenceNumber.threeDigitDecimalFormat.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.USER_ID_SEQUENCE_NUMBER, date));
			}
			
			return userId;
		}
	}
}
