package com.floreantpos.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.IOUtils;

import com.floreantpos.PosLog;

public class ConsentTemplateParamProvider {
	private static final ArrayList<ConsentTemplateParamModel> PARAM_LIST = new ArrayList<ConsentTemplateParamModel>();
	private static final ArrayList<ConsentTemplateParamModel> DATE_PARAM_LIST = new ArrayList<ConsentTemplateParamModel>();
	private static final ArrayList<ConsentTemplateParamModel> TIME_PARAM_LIST = new ArrayList<ConsentTemplateParamModel>();

	static {
		PARAM_LIST.add(new ConsentTemplateParamModel("$placeOfDeath", "Location of death (hospital name)."));
		PARAM_LIST.add(new ConsentTemplateParamModel("$childName", "Name of the child"));
		DATE_PARAM_LIST.add(new ConsentTemplateParamModel("$childDob", "Child date of birth"));
		TIME_PARAM_LIST.add(new ConsentTemplateParamModel("$childTob", "Child time of birth"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$childGender", "Sex of the child"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$cod", "Cause of death"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$doctorName", "Name of the doctor"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$doctorDesignation", "Designation of the doctor"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$diseaseName", "Disease name of the patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$patientName", "Name of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$patientGender", "Gender of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$patientAge", "Age of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$patientAddress", "Address of the patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$patientPhone", "Phone number of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$fathersName", "Father name"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$mothersName", "Mother name"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$fatherNID", "Father National ID Card Number"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$motherNID", "Mother National ID Card Number"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$permanentAddress", "Permanent address of the patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$midwife", "Who has assisted in child birth"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$husbandName", "Name of the Husband"));
		DATE_PARAM_LIST.add(new ConsentTemplateParamModel("$dod", "Date of death"));
		DATE_PARAM_LIST.add(new ConsentTemplateParamModel("$dob", "Date of birth"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$otName ", "Name of the OT"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$admissionId", "Admission Id of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$patientId", "Id of the Patient"));
		DATE_PARAM_LIST.add(new ConsentTemplateParamModel("$admissionDate", "Admission date of the Patient"));
		DATE_PARAM_LIST.add(new ConsentTemplateParamModel("$dischargeDate", "Discharge date of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$problems", "Problems of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$medicines", "Medicines given to the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$instructions", "Instructions given to the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$tests", "Tests given to the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$dischargeReason", "Discharge reason of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$dischargeSummary", "Discharge summary of the Patient"));
		PARAM_LIST.add(new ConsentTemplateParamModel("$consentSignBy", "Name of the consent signer"));
		PARAM_LIST.addAll(DATE_PARAM_LIST);
		PARAM_LIST.addAll(TIME_PARAM_LIST);
	}

	public static ArrayList<ConsentTemplateParamModel> getParamList() {
		return PARAM_LIST;
	}

	public static List<ConsentTemplateParamModel> getDateParamList() {
		return DATE_PARAM_LIST;
	}

	public static List<ConsentTemplateParamModel> getTimeParamList() {
		return TIME_PARAM_LIST;
	}

	public static String getDefaultTamplete(ConsentType consentType) {
		String fileName = null;

		switch (consentType) {
			case OT_CONSENT:
				fileName = "ConsentTemplate_OT.txt";
				break;
			case BIRTH_CERTIFICATE:
				fileName = "ConsentTemplate_Birth.txt";
				break;
			case DEATH_CERTIFICATE:
				fileName = "ConsentTemplate_Death.txt";
				break;
			case DISCHARGE_CERTIFICATE:
				fileName = "ConsentTemplate_Discharge.txt";
				break;
		}

		if (fileName == null) {
			return null;
		}

		try (InputStream inputStream = ConsentTemplateParamProvider.class.getResourceAsStream("/" + fileName);) {
			return IOUtils.toString(inputStream, "utf-8");
		} catch (IOException e) {
			PosLog.error(ConsentTemplateParamProvider.class, e);
		}
		return null;
	}
}
