package com.floreantpos.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.constants.AppConstants;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.OutletDAO;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class PaymentMethodJsonExtractor {
	public static final String JSON_PROP_PAYMENT_GATEWAY_ID = "payment-gateway-id";
	public static final String JSON_PROP_PAYMENT_TYPE_NAME = "payment_type_name";
	public static final String JSON_PROP_PAYMENT_GATEWAY_NAME = "gateway";

	public static final String PROP_PAYMENT_METHOD_COFIG_KEY = "configuration";

	public static final String PROP_PAYMENT_METHOD_STRIPE_API_KEY = "stripe.apikey";

	public static final String PROP_PAYMENT_METHOD_AUTHORIZE_DOT_NET_LOGIN_ID_KEY = "authorize_dot_net.loginId";
	public static final String PROP_PAYMENT_METHOD_AUTHORIZE_DOT_NET_TRANS_KEY = "authorize_dot_net_trans.transKey";
	public static final String PROP_PAYMENT_METHOD_AUTHORIZE_DOT_NET_CHKSANDBOXMODE_KEY = "authorize_dot_net_chksandboxmode.loginId";

	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_HOST_SYSTEM_KEY = "card_connect_host.hostSystem";
	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_MERCHANT_ID_KEY = "card_connect_merchant_id.merchantId";
	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_USER_NAME_KEY = "card_connect_user_name.userName";
	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_PASSWORD_KEY = "card_connect_password.password";

	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_NAME_KEY = "custom_payment.name";
	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_REFERENCE_FIELD_NAME_KEY = "custom_payment.referenceFieldName";
	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_IS_REQUIRED_NO_KEY = "custom_payment.isRequiredNo";
	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_IS_ENABLE_KEY = "custom_payment.isEnable";

	public static String getGatewayName(JsonObject jsonObject) {
		if (!jsonObject.has(JSON_PROP_PAYMENT_GATEWAY_NAME)) {
			return "";
		}

		return jsonObject.get(JSON_PROP_PAYMENT_GATEWAY_NAME) == null ? "" : jsonObject.get(JSON_PROP_PAYMENT_GATEWAY_NAME).getAsString();
	}

	public static String getPaymentType(JsonObject jsonObject) {
		return jsonObject.get(JSON_PROP_PAYMENT_TYPE_NAME) == null ? "" : jsonObject.get(JSON_PROP_PAYMENT_TYPE_NAME).getAsString();
	}

	public static JsonObject getPaymentConfiguration(String pluginId) {

		JsonArray paymentsJsonArray = DataProvider.get().getOutlet().getPropertyStore().getAsJsonArray(AppConstants.JSON_PROP_PAYMENT_ARRAY_KEY);
		if (paymentsJsonArray != null) {

			Iterator<JsonElement> it = paymentsJsonArray.iterator();
			while (it.hasNext()) {
				JsonObject paymentMethodObject = (JsonObject) it.next();

				if (paymentMethodObject == null) {
					continue;
				}
				String paymentMethodId = paymentMethodObject.get(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_ID) == null ? "" //$NON-NLS-1$
						: paymentMethodObject.get(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_ID).getAsString();
				if (StringUtils.isBlank(paymentMethodId)) {
					continue;
				}

				if (paymentMethodId.equals(pluginId)) {
					return paymentMethodObject.get(PaymentMethodJsonExtractor.PROP_PAYMENT_METHOD_COFIG_KEY).getAsJsonObject();
				}

			}
		}

		return null;
	}

	public static List<AbstractFloreantPlugin> getCardPaymentPlugins() {
		List<AbstractFloreantPlugin> paymentMethods = new ArrayList<AbstractFloreantPlugin>();

		Outlet outlet = DataProvider.get().getOutlet();
		OutletDAO.getInstance().refresh(outlet);

		JsonArray paymentMethodJsonArray = outlet.getPropertyStore().getAsJsonArray(AppConstants.JSON_PROP_PAYMENT_ARRAY_KEY);
		if (paymentMethodJsonArray != null) {

			Iterator<JsonElement> it = paymentMethodJsonArray.iterator();
			while (it.hasNext()) {
				JsonObject paymentMethodObject = (JsonObject) it.next();

				if (paymentMethodObject == null) {
					continue;
				}
				String paymentMethodId = paymentMethodObject.get(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_ID) == null ? "" //$NON-NLS-1$
						: paymentMethodObject.get(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_ID).getAsString();
				String gatewayName = paymentMethodObject.get(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_NAME) == null ? "" //$NON-NLS-1$
						: paymentMethodObject.get(PaymentMethodJsonExtractor.JSON_PROP_PAYMENT_GATEWAY_NAME).getAsString();
				if (StringUtils.isBlank(gatewayName) || StringUtils.isBlank(paymentMethodId)) {
					continue;
				}
				AbstractFloreantPlugin plugin = ExtensionManager.findByPluginId(paymentMethodId);
				if (plugin != null) {
					paymentMethods.add(plugin);
				}

			}
		}
		return paymentMethods;
	}

	
	public static String getKey(JsonObject paymentMethodObject) {
		String gatewayName = getGatewayName(paymentMethodObject);
		String paymentType = getPaymentType(paymentMethodObject);
		return gatewayName + "_" + paymentType; //$NON-NLS-1$
	}
	
}
