package com.floreantpos.util;

import java.util.Calendar;
import java.util.Date;

import org.joda.time.Period;

import com.floreantpos.model.util.DateUtil;
import com.floreantpos.Messages;

public enum ChartDuration {
	TODAY(Messages.getString("ChartDuration.0")), WEEK(Messages.getString("ChartDuration.1")), HALF_MONTH( //$NON-NLS-1$//$NON-NLS-2$
			Messages.getString("ChartDuration.2")), MONTH(Messages.getString("ChartDuration.3")); //$NON-NLS-1$ //$NON-NLS-2$

	private String durationName;

	private ChartDuration(String durationName) {
		this.durationName = durationName;
	}

	public String getDurationName() {
		return durationName;
	}

	public static Date getFromDateBehind(ChartDuration duration) {
		return getFromDateBehind(Calendar.getInstance().getTime(), duration);
	}

	public static Date getFromDateBehind(Date toDate, ChartDuration duration) {
		Calendar calendar = Calendar.getInstance();
		if (toDate != null) {
			calendar.setTime(toDate);
		}
		if (duration == ChartDuration.WEEK) {
			calendar.add(Calendar.DAY_OF_MONTH, -6);
		}
		else if (duration == ChartDuration.HALF_MONTH) {
			calendar.add(Calendar.DAY_OF_MONTH, -14);
		}
		else if (duration == ChartDuration.MONTH) {
			calendar.add(Calendar.MONTH, -1);
		}
		Date fromDate = DateUtil.startOfDay(calendar.getTime());
		return fromDate;
	}

	public static int getHoursPeriod(ChartDuration duration) {
		return getHoursPeriod(Calendar.getInstance().getTime(), duration);
	}

	public static int getHoursPeriod(Date toDate, ChartDuration duration) {
		/*if(toDate==null) {
			toDate = Calendar.getInstance().getTime();
		}*/
		Date from = getFromDateBehind(toDate, duration);
		Period period = new Period(from.getTime(), toDate.getTime());
		int hourhs = 0;
		if (Math.abs(period.getMonths()) >= 1) {
			hourhs += (Math.abs(period.getMonths()) * 30 * 24);
		}
		if (Math.abs(period.getWeeks()) >= 1) {
			hourhs += (Math.abs(period.getWeeks()) * 7 * 24);
		}
		if (Math.abs(period.getDays()) >= 1) {
			hourhs += Math.abs(period.getDays() * 24);
		}
		if (Math.abs(period.getHours()) >= 1) {
			hourhs += Math.abs(period.getHours());
		}
		return hourhs;
	}

	@Override
	public String toString() {
		return this.durationName;
	}
}
